"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertsLocalStorage = void 0;
var _local_storage = require("../../../../../common/components/local_storage");
var _helpers = require("../../../../../common/components/local_storage/helpers");
var _constants = require("./constants");
var _config = require("../../common/config");
var _helpers2 = require("../chart_select/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAlertsLocalStorage = () => {
  const [alertViewSelection, setAlertViewSelection] = (0, _local_storage.useLocalStorage)({
    defaultValue: _helpers2.CHARTS_ID,
    key: (0, _helpers.getSettingKey)({
      category: _constants.VIEW_CATEGORY,
      page: _constants.ALERTS_PAGE,
      setting: _constants.ALERT_VIEW_SELECTION_SETTING_NAME
    }),
    isInvalidDefault: _helpers.isDefaultWhenEmptyString
  });
  const [groupBySelection, setGroupBySelection] = (0, _local_storage.useLocalStorage)({
    defaultValue: 'host.name',
    key: (0, _helpers.getSettingKey)({
      category: _constants.VIEW_CATEGORY,
      page: _constants.ALERTS_PAGE,
      setting: _constants.GROUP_BY_SETTING_NAME
    }),
    isInvalidDefault: _helpers.isDefaultWhenEmptyString
  });
  const [isTreemapPanelExpanded, setIsTreemapPanelExpanded] = (0, _local_storage.useLocalStorage)({
    defaultValue: true,
    key: (0, _helpers.getSettingKey)({
      category: _constants.TREEMAP_CATEGORY,
      page: _constants.ALERTS_PAGE,
      setting: _constants.EXPAND_SETTING_NAME
    })
  });
  const [riskChartStackBy0, setRiskChartStackBy0] = (0, _local_storage.useLocalStorage)({
    defaultValue: _config.DEFAULT_STACK_BY_FIELD,
    key: (0, _helpers.getSettingKey)({
      category: _constants.TREEMAP_CATEGORY,
      page: _constants.ALERTS_PAGE,
      setting: _constants.STACK_BY_0_SETTING_NAME
    }),
    isInvalidDefault: _helpers.isDefaultWhenEmptyString
  });
  const [riskChartStackBy1, setRiskChartStackBy1] = (0, _local_storage.useLocalStorage)({
    defaultValue: _config.DEFAULT_STACK_BY_FIELD1,
    key: (0, _helpers.getSettingKey)({
      category: _constants.TREEMAP_CATEGORY,
      page: _constants.ALERTS_PAGE,
      setting: _constants.STACK_BY_1_SETTING_NAME
    })
  });
  const [countTableStackBy0, setCountTableStackBy0] = (0, _local_storage.useLocalStorage)({
    defaultValue: _config.DEFAULT_STACK_BY_FIELD,
    key: (0, _helpers.getSettingKey)({
      category: _constants.TABLE_CATEGORY,
      page: _constants.ALERTS_PAGE,
      setting: _constants.STACK_BY_0_SETTING_NAME
    }),
    isInvalidDefault: _helpers.isDefaultWhenEmptyString
  });
  const [countTableStackBy1, setCountTableStackBy1] = (0, _local_storage.useLocalStorage)({
    defaultValue: _config.DEFAULT_STACK_BY_FIELD1,
    key: (0, _helpers.getSettingKey)({
      category: _constants.TABLE_CATEGORY,
      page: _constants.ALERTS_PAGE,
      setting: _constants.STACK_BY_1_SETTING_NAME
    })
  });
  const [trendChartStackBy, setTrendChartStackBy] = (0, _local_storage.useLocalStorage)({
    defaultValue: _config.DEFAULT_STACK_BY_FIELD,
    key: (0, _helpers.getSettingKey)({
      category: _constants.TREND_CHART_CATEGORY,
      page: _constants.ALERTS_PAGE,
      setting: _constants.STACK_BY_SETTING_NAME
    }),
    isInvalidDefault: _helpers.isDefaultWhenEmptyString
  });
  return {
    alertViewSelection,
    countTableStackBy0,
    countTableStackBy1,
    groupBySelection,
    isTreemapPanelExpanded,
    riskChartStackBy0,
    riskChartStackBy1,
    setAlertViewSelection,
    setCountTableStackBy0,
    setCountTableStackBy1,
    setGroupBySelection,
    setIsTreemapPanelExpanded,
    setRiskChartStackBy0,
    setRiskChartStackBy1,
    setTrendChartStackBy,
    trendChartStackBy
  };
};
exports.useAlertsLocalStorage = useAlertsLocalStorage;