"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLayersOneDimension = exports.getLayersMultiDimensional = exports.getGroupFromPath = void 0;
var _chart_palette = require("../chart_palette");
var _labels = require("../labels");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// common functions used by getLayersOneDimension and getLayersMultiDimensional:
const valueFormatter = d => `${d}`;
const groupByRollup = d => d.key;

/**
 * Extracts the first group name from the data representing the second group
 */
const getGroupFromPath = path => {
  const OFFSET_FROM_END = 2; // The offset from the end of the path array containing the group
  const groupIndex = path.length - OFFSET_FROM_END;
  return groupIndex > 0 ? path[groupIndex].value : undefined;
};
exports.getGroupFromPath = getGroupFromPath;
const getLayersOneDimension = ({
  colorPalette,
  maxRiskSubAggregations
}) => [{
  fillLabel: {
    valueFormatter
  },
  groupByRollup,
  nodeLabel: d => (0, _labels.getLabel)({
    baseLabel: d,
    riskScore: maxRiskSubAggregations[d]
  }),
  shape: {
    fillColor: dataName => {
      var _maxRiskSubAggregatio;
      return (0, _chart_palette.getFillColor)({
        riskScore: (_maxRiskSubAggregatio = maxRiskSubAggregations[dataName]) !== null && _maxRiskSubAggregatio !== void 0 ? _maxRiskSubAggregatio : 0,
        colorPalette
      });
    }
  }
}];
exports.getLayersOneDimension = getLayersOneDimension;
const getLayersMultiDimensional = ({
  colorPalette,
  layer0FillColor,
  maxRiskSubAggregations
}) => [{
  fillLabel: {
    valueFormatter
  },
  groupByRollup,
  nodeLabel: d => (0, _labels.getLabel)({
    baseLabel: d,
    riskScore: maxRiskSubAggregations[d]
  }),
  shape: {
    fillColor: layer0FillColor
  }
}, {
  fillLabel: {
    valueFormatter
  },
  groupByRollup: d => d.stackByField1Key,
  // different implementation than layer 0
  nodeLabel: d => `${d}`,
  shape: {
    fillColor: (dataName, sortIndex, node) => {
      var _getGroupFromPath, _maxRiskSubAggregatio2;
      const groupFromPath = (_getGroupFromPath = getGroupFromPath(node.path)) !== null && _getGroupFromPath !== void 0 ? _getGroupFromPath : '';
      return (0, _chart_palette.getFillColor)({
        riskScore: (_maxRiskSubAggregatio2 = maxRiskSubAggregations[groupFromPath]) !== null && _maxRiskSubAggregatio2 !== void 0 ? _maxRiskSubAggregatio2 : 0,
        colorPalette
      });
    }
  }
}];
exports.getLayersMultiDimensional = getLayersMultiDimensional;