"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsByRule = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _columns = require("./columns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Wrapper = _styledComponents.default.div`
  margin-top: -${({
  theme
}) => theme.eui.euiSizeM};
`;
const TableWrapper = _styledComponents.default.div`
  height: 210px;
`;
const SORTING = {
  sort: {
    field: 'value',
    direction: 'desc'
  }
};
const PAGINATION = {
  pageSize: 25,
  showPerPageOptions: false
};
const AlertsByRule = ({
  data,
  isLoading,
  showCellActions
}) => {
  const columns = (0, _columns.useGetAlertsByRuleColumns)(showCellActions);
  return /*#__PURE__*/_react.default.createElement(Wrapper, {
    "data-test-subj": "alerts-by-rule"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(TableWrapper, {
    className: "eui-yScroll"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    "data-test-subj": "alerts-by-rule-table",
    columns: columns,
    items: data,
    loading: isLoading,
    sorting: SORTING,
    pagination: PAGINATION
  })));
};
exports.AlertsByRule = AlertsByRule;
AlertsByRule.displayName = 'AlertsByRule';