"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchBarSection = exports.SEARCH_BAR_TEST_ID = exports.INTEGRATION_BUTTON_LOADING_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_integrations = require("../../../hooks/alert_summary/use_integrations");
var _search_bar = require("../../../../common/components/search_bar");
var _integrations_filter_button = require("./integrations_filter_button");
var _constants = require("../../../../common/store/inputs/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INTEGRATION_BUTTON_LOADING_TEST_ID = exports.INTEGRATION_BUTTON_LOADING_TEST_ID = 'alert-summary-integration-button-loading';
const SEARCH_BAR_TEST_ID = exports.SEARCH_BAR_TEST_ID = 'alert-summary-search-bar';
const INTEGRATION_BUTTON_LOADING_WIDTH = '120px';
const INTEGRATION_BUTTON_LOADING_HEIGHT = '40px';
/**
 * KQL bar at the top of the alert summary page.
 * The component leverages the Security Solution SiemSearchBar which has a lot of logic tied to url and redux to store its values.
 * The component also has a filter button to the left of the KQL bar that allows user to select integrations.
 * For the AI for SOC effort, each integration has one rule associated with.
 * This means that deselecting an integration is equivalent to filtering out by the rule for that integration.
 */
const SearchBarSection = exports.SearchBarSection = /*#__PURE__*/(0, _react.memo)(({
  dataView,
  packages,
  ruleResponse
}) => {
  const {
    isLoading,
    integrations
  } = (0, _use_integrations.useIntegrations)({
    packages,
    ruleResponse
  });
  const dataViewSpec = (0, _react.useMemo)(() => dataView.toSpec(), [dataView]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    "data-test-subj": INTEGRATION_BUTTON_LOADING_TEST_ID,
    isLoading: isLoading,
    width: INTEGRATION_BUTTON_LOADING_WIDTH,
    height: INTEGRATION_BUTTON_LOADING_HEIGHT
  }, /*#__PURE__*/_react.default.createElement(_integrations_filter_button.IntegrationFilterButton, {
    integrations: integrations
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    dataTestSubj: SEARCH_BAR_TEST_ID,
    hideFilterBar: true,
    hideQueryMenu: true,
    id: _constants.InputsModelId.global,
    sourcererDataView: dataViewSpec
  })));
});
SearchBarSection.displayName = 'SearchBarSection';