"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponseActionsWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _response_actions_list = require("./response_actions_list");
var _response_action_add_button = require("./response_action_add_button");
var _shared_imports = require("../../shared_imports");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResponseActionsWrapper = exports.ResponseActionsWrapper = /*#__PURE__*/_react.default.memo(({
  items,
  removeItem,
  supportedResponseActionTypes,
  addItem
}) => {
  const actionTypeIdRef = (0, _react.useRef)(null);
  const updateActionTypeId = (0, _react.useCallback)(id => {
    actionTypeIdRef.current = id;
  }, []);
  const context = (0, _shared_imports.useFormContext)();
  const renderButton = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_response_action_add_button.ResponseActionAddButton, {
      supportedResponseActionTypes: supportedResponseActionTypes,
      addActionType: addItem,
      updateActionTypeId: updateActionTypeId
    });
  }, [addItem, updateActionTypeId, supportedResponseActionTypes]);
  (0, _react.useEffect)(() => {
    if (actionTypeIdRef.current) {
      const index = items.length - 1;
      const path = `responseActions[${index}].actionTypeId`;
      context.setFieldValue(path, actionTypeIdRef.current);
      actionTypeIdRef.current = null;
    }
  }, [context, items.length]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "response-actions-wrapper"
  }, /*#__PURE__*/_react.default.createElement(_response_actions_list.ResponseActionsList, {
    items: items,
    removeItem: removeItem
  }), renderButton);
});
ResponseActionsWrapper.displayName = 'ResponseActionsWrapper';