"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CoverageOverviewMitreTechniquePanel = void 0;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _react = _interopRequireWildcard(require("react"));
var _mitre_technique = require("../../../rule_management/model/coverage_overview/mitre_technique");
var _constants = require("./constants");
var _coverage_overview_dashboard_context = require("./coverage_overview_dashboard_context");
var _helpers = require("./helpers");
var _panel_rule_stats = require("./shared_components/panel_rule_stats");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CoverageOverviewMitreTechniquePanelComponent = ({
  technique,
  coveredSubtechniques,
  setIsPopoverOpen,
  isPopoverOpen,
  isExpanded
}) => {
  const {
    state: {
      filter
    }
  } = (0, _coverage_overview_dashboard_context.useCoverageOverviewDashboardContext)();
  const totalRuleCount = (0, _mitre_technique.getTotalRuleCount)(technique, filter.activity);
  const techniqueBackgroundColor = (0, _react.useMemo)(() => (0, _helpers.getCardBackgroundColor)(totalRuleCount), [totalRuleCount]);
  const handlePanelOnClick = (0, _react.useCallback)(() => setIsPopoverOpen(!isPopoverOpen), [isPopoverOpen, setIsPopoverOpen]);
  const SubtechniqueInfo = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: (0, _css.css)`
            white-space: nowrap;
          `,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, i18n.SUBTECHNIQUES)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, `${coveredSubtechniques}/${technique.subtechniques.length}`))), [technique.subtechniques, coveredSubtechniques]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "coverageOverviewTechniquePanel",
    className: (0, _css.css)`
        background: ${techniqueBackgroundColor};
        width: ${_constants.coverageOverviewPanelWidth}px;
      `,
    hasShadow: false,
    hasBorder: !techniqueBackgroundColor,
    paddingSize: "s",
    onClick: handlePanelOnClick,
    element: "div"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: {
      height: '100%'
    },
    direction: "column",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": `coverageOverviewTechniqueTitle-${technique.id}`,
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, technique.name)), SubtechniqueInfo), isExpanded && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_panel_rule_stats.CoverageOverviewPanelRuleStats, {
    enabledRules: technique.enabledRules.length,
    disabledRules: technique.disabledRules.length
  }))));
};
const CoverageOverviewMitreTechniquePanel = exports.CoverageOverviewMitreTechniquePanel = /*#__PURE__*/(0, _react.memo)(CoverageOverviewMitreTechniquePanelComponent);