"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsElementMounted = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIsElementMounted = elementId => {
  const [isElementMounted, setIsElementMounted] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    const observer = new MutationObserver(() => {
      const isElementFound = !!document.getElementById(elementId);
      if (isElementFound && !isElementMounted) {
        setIsElementMounted(true);
      }
      if (!isElementFound && isElementMounted) {
        setIsElementMounted(false);
      }
    });
    observer.observe(document.body, {
      childList: true,
      subtree: true
    });
    return () => observer.disconnect();
  }, [isElementMounted, elementId]);
  return isElementMounted;
};
exports.useIsElementMounted = useIsElementMounted;