"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddPrebuiltRulesTable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("../../../pages/add_rules/translations"));
var _constants = require("../constants");
var _rules_changelog_link = require("../rules_changelog_link");
var _add_prebuilt_rules_no_items_message = require("./add_prebuilt_rules_no_items_message");
var _add_prebuilt_rules_table_context = require("./add_prebuilt_rules_table_context");
var _add_prebuilt_rules_table_filters = require("./add_prebuilt_rules_table_filters");
var _use_add_prebuilt_rules_table_columns = require("./use_add_prebuilt_rules_table_columns");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Table Component for displaying new rules that are available to be installed
 */
const AddPrebuiltRulesTable = exports.AddPrebuiltRulesTable = /*#__PURE__*/_react.default.memo(() => {
  const {
    state: {
      rules,
      hasRulesToInstall,
      isLoading,
      isFetching,
      isRefetching,
      selectedRules,
      isUpgradingSecurityPackages,
      pagination,
      sortingOptions
    },
    actions: {
      setPagination,
      setSortingOptions,
      selectRules
    }
  } = (0, _add_prebuilt_rules_table_context.useAddPrebuiltRulesTableContext)();
  const rulesColumns = (0, _use_add_prebuilt_rules_table_columns.useAddPrebuiltRulesTableColumns)();
  const shouldShowProgress = isUpgradingSecurityPackages || isRefetching;
  const handleTableChange = (0, _react.useCallback)(({
    page: {
      index,
      size
    },
    sort
  }) => {
    setPagination({
      page: index + 1,
      perPage: size
    });
    if (sort) {
      setSortingOptions({
        field: sort.field,
        order: sort.direction
      });
    }
  }, [setPagination, setSortingOptions]);
  const sortingTableProp = (0, _react.useMemo)(() => {
    return sortingOptions ? {
      sort: {
        field: sortingOptions.field,
        direction: sortingOptions.order
      }
    } : {};
  }, [sortingOptions]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, shouldShowProgress && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    "data-test-subj": "loadingRulesInfoProgress",
    size: "xs",
    position: "absolute",
    color: "accent"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonLoading, {
    isLoading: isLoading,
    loadingContent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, null)),
    loadedContent: !hasRulesToInstall ? /*#__PURE__*/_react.default.createElement(_add_prebuilt_rules_no_items_message.AddPrebuiltRulesTableNoItemsMessage, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      css: {
        alignSelf: 'start'
      }
    }, /*#__PURE__*/_react.default.createElement(_rules_changelog_link.RulesChangelogLink, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_add_prebuilt_rules_table_filters.AddPrebuiltRulesTableFilters, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
      loading: isFetching,
      items: rules,
      pagination: {
        totalItemCount: pagination.total,
        pageSizeOptions: _constants.RULES_TABLE_PAGE_SIZE_OPTIONS,
        pageIndex: pagination.page - 1,
        pageSize: pagination.perPage
      },
      selection: {
        selectable: () => true,
        onSelectionChange: selectRules,
        initialSelected: selectedRules
      },
      sorting: sortingTableProp,
      itemId: "rule_id",
      "data-test-subj": "add-prebuilt-rules-table",
      columns: rulesColumns,
      onChange: handleTableChange,
      tableCaption: i18n.PAGE_TITLE
    }))
  }));
});
AddPrebuiltRulesTable.displayName = 'AddPrebuiltRulesTable';