"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrebuiltRulesInstallButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _useBoolean = _interopRequireDefault(require("react-use/lib/useBoolean"));
var _add_prebuilt_rules_table_context = require("./add_prebuilt_rules_table_context");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PrebuiltRulesInstallButton = ({
  ruleId,
  record,
  installOneRule,
  loadingRules,
  isDisabled
}) => {
  const {
    state: {
      isInstallingAllRules
    }
  } = (0, _add_prebuilt_rules_table_context.useAddPrebuiltRulesTableContext)();
  const isRuleInstalling = loadingRules.includes(ruleId) || isInstallingAllRules;
  const isInstallButtonDisabled = isRuleInstalling || isDisabled;
  const [isPopoverOpen, setPopover] = (0, _useBoolean.default)(false);
  const onOverflowButtonClick = (0, _react.useCallback)(() => {
    setPopover(!isPopoverOpen);
  }, [isPopoverOpen, setPopover]);
  const closeOverflowPopover = (0, _react.useCallback)(() => {
    setPopover(false);
  }, [setPopover]);
  const enableOnClick = (0, _react.useCallback)(() => {
    installOneRule(ruleId, true);
    closeOverflowPopover();
  }, [closeOverflowPopover, installOneRule, ruleId]);
  const installOnClick = (0, _react.useCallback)(() => {
    installOneRule(ruleId);
  }, [installOneRule, ruleId]);
  const overflowItems = (0, _react.useMemo)(() => [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "copy",
    icon: 'play',
    onClick: enableOnClick
  }, i18n.INSTALL_AND_ENABLE_BUTTON_LABEL)], [enableOnClick]);
  const popoverButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    display: "empty",
    size: "s",
    iconType: "boxesVertical",
    "aria-label": i18n.INSTALL_RULES_OVERFLOW_BUTTON_ARIA_LABEL,
    onClick: onOverflowButtonClick,
    disabled: isInstallButtonDisabled
  }), [isInstallButtonDisabled, onOverflowButtonClick]);
  if (isRuleInstalling) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "s",
      "data-test-subj": `installSinglePrebuiltRuleButton-loadingSpinner-${ruleId}`
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    disabled: isInstallButtonDisabled,
    onClick: installOnClick,
    "data-test-subj": `installSinglePrebuiltRuleButton-${ruleId}`,
    "aria-label": i18n.INSTALL_RULE_BUTTON_ARIA_LABEL(record.name)
  }, i18n.INSTALL_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: popoverButton,
    isOpen: isPopoverOpen,
    closePopover: closeOverflowPopover,
    panelPaddingSize: "s",
    anchorPosition: "downRight"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: overflowItems
  }))));
};
exports.PrebuiltRulesInstallButton = PrebuiltRulesInstallButton;