"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUCCESSFULLY_IMPORTED_RULES = exports.SUCCESSFULLY_IMPORTED_EXCEPTIONS = exports.SUCCESSFULLY_IMPORTED_CONNECTORS = exports.SELECT_RULE = exports.RULE_IMPORT_FAILED = exports.OVERWRITE_WITH_SAME_NAME = exports.OVERWRITE_EXCEPTIONS_LABEL = exports.OVERWRITE_ACTION_CONNECTORS_LABEL = exports.MULTIPLE_ISSUES = exports.INITIAL_PROMPT_TEXT = exports.IMPORT_RULE_BTN_TITLE = exports.EXCEPTION_IMPORT_FAILED = exports.CONNECTOR_IMPORT_FAILED = exports.ACTION_CONNECTORS_WARNING_TITLE = exports.ACTION_CONNECTORS_WARNING_BUTTON = exports.ACTION_CONNECTORS_ADDITIONAL_PRIVILEGES = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IMPORT_RULE_BTN_TITLE = exports.IMPORT_RULE_BTN_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.importRuleTitle', {
  defaultMessage: 'Import'
});
const SELECT_RULE = exports.SELECT_RULE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.selectRuleDescription', {
  defaultMessage: 'Select rules to import. Associated rule actions and exceptions can be included.'
});
const INITIAL_PROMPT_TEXT = exports.INITIAL_PROMPT_TEXT = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.initialPromptTextDescription', {
  defaultMessage: 'Select or drag and drop a valid rules_export.ndjson file'
});
const OVERWRITE_WITH_SAME_NAME = exports.OVERWRITE_WITH_SAME_NAME = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.overwriteDescription', {
  defaultMessage: 'Overwrite existing detection rules with conflicting "rule_id"'
});
const OVERWRITE_EXCEPTIONS_LABEL = exports.OVERWRITE_EXCEPTIONS_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.overwriteExceptionLabel', {
  defaultMessage: 'Overwrite existing exception lists with conflicting "list_id"'
});
const OVERWRITE_ACTION_CONNECTORS_LABEL = exports.OVERWRITE_ACTION_CONNECTORS_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.overwriteActionConnectorsLabel', {
  defaultMessage: 'Overwrite existing connectors with conflicting action "id"'
});
const SUCCESSFULLY_IMPORTED_RULES = totalRules => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.successfullyImportedRulesTitle', {
  values: {
    totalRules
  },
  defaultMessage: 'Successfully imported {totalRules} {totalRules, plural, =1 {rule} other {rules}}'
});
exports.SUCCESSFULLY_IMPORTED_RULES = SUCCESSFULLY_IMPORTED_RULES;
const SUCCESSFULLY_IMPORTED_EXCEPTIONS = totalExceptions => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.exceptionsSuccessLabel', {
  values: {
    totalExceptions
  },
  defaultMessage: 'Successfully imported {totalExceptions} {totalExceptions, plural, =1 {exception} other {exceptions}}'
});
exports.SUCCESSFULLY_IMPORTED_EXCEPTIONS = SUCCESSFULLY_IMPORTED_EXCEPTIONS;
const SUCCESSFULLY_IMPORTED_CONNECTORS = totalConnectors => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.connectorsSuccessLabel', {
  values: {
    totalConnectors
  },
  defaultMessage: 'Successfully imported {totalConnectors} {totalConnectors, plural, =1 {connector} other {connectors}}'
});
exports.SUCCESSFULLY_IMPORTED_CONNECTORS = SUCCESSFULLY_IMPORTED_CONNECTORS;
const RULE_IMPORT_FAILED = totalRules => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.importFailedTitle', {
  values: {
    totalRules
  },
  defaultMessage: 'Failed to import {totalRules} {totalRules, plural, =1 {rule} other {rules}}'
});
exports.RULE_IMPORT_FAILED = RULE_IMPORT_FAILED;
const CONNECTOR_IMPORT_FAILED = totalConnectors => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.importConnectorsFailedLabel', {
  values: {
    totalConnectors
  },
  defaultMessage: 'Failed to import {totalConnectors, plural, =0 {connectors} =1 {# connector} other {# connectors}}'
});
exports.CONNECTOR_IMPORT_FAILED = CONNECTOR_IMPORT_FAILED;
const EXCEPTION_IMPORT_FAILED = totalExceptions => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.importExceptionsFailedLabel', {
  values: {
    totalExceptions
  },
  defaultMessage: 'Failed to import {totalExceptions} {totalExceptions, plural, =1 {exception} other {exceptions}}'
});
exports.EXCEPTION_IMPORT_FAILED = EXCEPTION_IMPORT_FAILED;
const ACTION_CONNECTORS_WARNING_TITLE = totalConnectors => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.actionConnectorsWarningTitle', {
  values: {
    totalConnectors
  },
  defaultMessage: '{totalConnectors} {totalConnectors, plural, =1 {connector} other {connectors}} imported'
});
exports.ACTION_CONNECTORS_WARNING_TITLE = ACTION_CONNECTORS_WARNING_TITLE;
const ACTION_CONNECTORS_WARNING_BUTTON = exports.ACTION_CONNECTORS_WARNING_BUTTON = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.actionConnectorsWarningButton', {
  defaultMessage: 'Go to connectors'
});
const ACTION_CONNECTORS_ADDITIONAL_PRIVILEGES = exports.ACTION_CONNECTORS_ADDITIONAL_PRIVILEGES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.actionConnectorsAdditionalPrivilegesError', {
  defaultMessage: 'You need additional privileges to import rules with actions.'
});
const MULTIPLE_ISSUES = exports.MULTIPLE_ISSUES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.multipleIssuesError', {
  defaultMessage: 'Multiple issues. See the full error for details.'
});