"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePrebuiltRulesInstallReview = void 0;
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var i18n = _interopRequireWildcard(require("../translations"));
var _use_fetch_prebuilt_rules_install_review_query = require("../../api/hooks/prebuilt_rules/use_fetch_prebuilt_rules_install_review_query");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A wrapper around useQuery provides default values to the underlying query,
 * like query key, abortion signal, and error handler.
 *
 * @returns useQuery result
 */
const usePrebuiltRulesInstallReview = (requestParameters, options) => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  return (0, _use_fetch_prebuilt_rules_install_review_query.useFetchPrebuiltRulesInstallReviewQuery)({
    page: requestParameters.page,
    per_page: requestParameters.perPage,
    filter: prepareFilters(requestParameters.filterOptions),
    sort: requestParameters.sortingOptions ? [requestParameters.sortingOptions] : undefined
  }, {
    onError: error => addError(error, {
      title: i18n.RULE_AND_TIMELINE_FETCH_FAILURE
    }),
    ...options
  });
};

/**
 * Converts filter options from a simplified UI format to a format expected by the API.
 */
exports.usePrebuiltRulesInstallReview = usePrebuiltRulesInstallReview;
function prepareFilters(filterOptions) {
  if (!filterOptions) {
    return undefined;
  }
  const filter = {
    fields: {}
  };
  if (filterOptions.name) {
    filter.fields.name = {
      include: {
        values: [filterOptions.name]
      }
    };
  }
  if (filterOptions.tags.length) {
    filter.fields.tags = {
      include: {
        values: filterOptions.tags
      }
    };
  }
  const isEmptyFilter = Object.keys(filter.fields).length === 0;
  return isEmptyFilter ? undefined : filter;
}