"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldFinalSideMode = void 0;
exports.FieldUpgradeContextProvider = FieldUpgradeContextProvider;
exports.useFieldUpgradeContext = useFieldUpgradeContext;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _reactHooks = require("@kbn/react-hooks");
var _rule_preview_context = require("../../../../../rule_management_ui/components/rules_table/upgrade_prebuilt_rules_table/rule_preview_context");
var _utility_types = require("../../../../../../../common/utility_types");
var _detection_engine = require("../../../../../../../common/api/detection_engine");
var _invariant = require("../../../../../../../common/utils/invariant");
var _convert_rule_to_diffable = require("../../../../../../../common/detection_engine/prebuilt_rules/diff/convert_rule_to_diffable");
var _prebuilt_rule_upgrade = require("../../../../model/prebuilt_rule_upgrade");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let FieldFinalSideMode = exports.FieldFinalSideMode = /*#__PURE__*/function (FieldFinalSideMode) {
  FieldFinalSideMode["Readonly"] = "readonly";
  FieldFinalSideMode["Edit"] = "edit";
  return FieldFinalSideMode;
}({});
const FieldUpgradeContext = /*#__PURE__*/(0, _react.createContext)(null);
function FieldUpgradeContextProvider({
  ruleUpgradeState,
  fieldName,
  setRuleFieldResolvedValue,
  children
}) {
  const {
    state: fieldUpgradeState
  } = ruleUpgradeState.fieldsUpgradeState[fieldName];
  const fieldDiff = ruleUpgradeState.diff.fields[fieldName];
  const initialRightSideMode = fieldUpgradeState === _prebuilt_rule_upgrade.FieldUpgradeStateEnum.NonSolvableConflict ? FieldFinalSideMode.Edit : FieldFinalSideMode.Readonly;
  const [editing, {
    on: setEditMode,
    off: setReadOnlyMode
  }] = (0, _reactHooks.useBoolean)(initialRightSideMode === FieldFinalSideMode.Edit);
  const {
    setFieldEditing,
    setFieldReadonly
  } = (0, _rule_preview_context.useRulePreviewContext)();
  (0, _react.useEffect)(() => {
    if (editing) {
      setFieldEditing(fieldName);
    } else {
      setFieldReadonly(fieldName);
    }
  }, [setFieldEditing, setFieldReadonly, editing, fieldName]);
  (0, _invariant.invariant)(fieldDiff, `Field diff is not found for ${fieldName}.`);
  const finalDiffableRule = calcFinalDiffableRule(ruleUpgradeState);
  const contextValue = (0, _react.useMemo)(() => ({
    fieldName,
    fieldUpgradeState,
    hasConflict: fieldUpgradeState === _prebuilt_rule_upgrade.FieldUpgradeStateEnum.SolvableConflict || fieldUpgradeState === _prebuilt_rule_upgrade.FieldUpgradeStateEnum.NonSolvableConflict,
    /*
      Initially, we prefill the resolved value with the merged version.
      If the current resolved value differs from the merged version, it indicates that the user has modified the suggestion.
    */
    hasResolvedValueDifferentFromSuggested: !(0, _lodash.isEqual)(fieldDiff.merged_version, finalDiffableRule[fieldName]),
    isCustomized: calcIsCustomized(fieldDiff),
    fieldDiff,
    finalDiffableRule,
    rightSideMode: editing ? FieldFinalSideMode.Edit : FieldFinalSideMode.Readonly,
    setRuleFieldResolvedValue,
    setReadOnlyMode,
    setEditMode
  }), [fieldName, fieldUpgradeState, fieldDiff, finalDiffableRule, editing, setRuleFieldResolvedValue, setReadOnlyMode, setEditMode]);
  return /*#__PURE__*/_react.default.createElement(FieldUpgradeContext.Provider, {
    value: contextValue
  }, children);
}
function useFieldUpgradeContext() {
  const context = (0, _react.useContext)(FieldUpgradeContext);
  (0, _invariant.invariant)(context !== null, 'useFieldUpgradeContext must be used inside a FieldUpgradeContextProvider');
  return context;
}
function calcIsCustomized(fieldDiff) {
  switch (fieldDiff.diff_outcome) {
    case _detection_engine.ThreeWayDiffOutcome.StockValueNoUpdate:
    case _detection_engine.ThreeWayDiffOutcome.StockValueCanUpdate:
    case _detection_engine.ThreeWayDiffOutcome.MissingBaseCanUpdate:
    case _detection_engine.ThreeWayDiffOutcome.MissingBaseNoUpdate:
      return false;
    case _detection_engine.ThreeWayDiffOutcome.CustomizedValueCanUpdate:
    case _detection_engine.ThreeWayDiffOutcome.CustomizedValueSameUpdate:
    case _detection_engine.ThreeWayDiffOutcome.CustomizedValueNoUpdate:
      return true;
    default:
      return (0, _utility_types.assertUnreachable)(fieldDiff.diff_outcome);
  }
}
function calcFinalDiffableRule(ruleUpgradeState) {
  const fieldsResolvedValues = Object.entries(ruleUpgradeState.fieldsUpgradeState).reduce((result, [fieldName, fieldState]) => {
    if (fieldState.state === _prebuilt_rule_upgrade.FieldUpgradeStateEnum.Accepted) {
      result[fieldName] = fieldState.resolvedValue;
    }
    return result;
  }, {});
  return {
    ...(0, _convert_rule_to_diffable.convertRuleToDiffable)(ruleUpgradeState.target_rule),
    ...convertRuleFieldsDiffToDiffable(ruleUpgradeState.diff.fields),
    ...fieldsResolvedValues
  };
}

/**
 * Assembles a `DiffableRule` from rule fields diff `merged_version`s.
 */
function convertRuleFieldsDiffToDiffable(ruleFieldsDiff) {
  const mergeVersionRule = {};
  for (const fieldName of Object.keys(ruleFieldsDiff)) {
    mergeVersionRule[fieldName] = ruleFieldsDiff[fieldName].merged_version;
  }
  return mergeVersionRule;
}