"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertSuppressionReadOnly = AlertSuppressionReadOnly;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var ruleDetailsI18n = _interopRequireWildcard(require("../../../../translations"));
var _alert_suppression_label = require("../../../../../../../rule_creation_ui/components/description_step/alert_suppression_label");
var _rule_definition_section = require("../../../../rule_definition_section");
var _empty_field_value_placeholder = require("../../empty_field_value_placeholder");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AlertSuppressionReadOnly({
  alertSuppression,
  ruleType
}) {
  if (!alertSuppression) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      listItems: [{
        title: ruleDetailsI18n.ALERT_SUPPRESSION_FIELD_LABEL,
        description: /*#__PURE__*/_react.default.createElement(_empty_field_value_placeholder.EmptyFieldValuePlaceholder, null)
      }]
    });
  }
  const listItems = [];
  if ('group_by' in alertSuppression) {
    listItems.push({
      title: /*#__PURE__*/_react.default.createElement(_alert_suppression_label.AlertSuppressionLabel, {
        label: ruleDetailsI18n.SUPPRESS_ALERTS_BY_FIELD_LABEL,
        ruleType: ruleType
      }),
      description: /*#__PURE__*/_react.default.createElement(_rule_definition_section.SuppressAlertsByField, {
        fields: alertSuppression.group_by
      })
    });
  }
  if ('duration' in alertSuppression) {
    listItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "alertSuppressionDurationPropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_alert_suppression_label.AlertSuppressionLabel, {
        label: ruleDetailsI18n.SUPPRESS_ALERTS_DURATION_FIELD_LABEL,
        ruleType: ruleType
      })),
      description: /*#__PURE__*/_react.default.createElement(_rule_definition_section.SuppressAlertsDuration, {
        duration: alertSuppression.duration
      })
    });
  }
  if ('missing_fields_strategy' in alertSuppression) {
    listItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "alertSuppressionMissingFieldPropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_alert_suppression_label.AlertSuppressionLabel, {
        label: ruleDetailsI18n.SUPPRESSION_FIELD_MISSING_FIELD_LABEL,
        ruleType: ruleType
      })),
      description: /*#__PURE__*/_react.default.createElement(_rule_definition_section.MissingFieldsStrategy, {
        missingFieldsStrategy: alertSuppression.missing_fields_strategy
      })
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: listItems
  });
}