"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldFinalSideContent = FieldFinalSideContent;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _sharedUxErrorBoundary = require("@kbn/shared-ux-error-boundary");
var _final_readonly = require("../../final_readonly");
var _final_edit = require("../../final_edit");
var _utility_types = require("../../../../../../../../common/utility_types");
var _field_upgrade_context = require("../../rule_upgrade/field_upgrade_context");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FieldFinalSideContent() {
  const {
    rightSideMode,
    setEditMode,
    setReadOnlyMode
  } = (0, _field_upgrade_context.useFieldUpgradeContext)();
  switch (rightSideMode) {
    case _field_upgrade_context.FieldFinalSideMode.Readonly:
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "flexEnd"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        iconType: "pencil",
        onClick: setEditMode,
        "data-test-subj": "prebuilt-rule-upgrade-flyout-field-edit"
      }, i18n.EDIT)), /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaSectionErrorBoundary, {
        key: "rule-field-readonly-view",
        sectionName: i18n.READONLY_MODE
      }, /*#__PURE__*/_react.default.createElement(_final_readonly.FieldFinalReadOnly, null)));
    case _field_upgrade_context.FieldFinalSideMode.Edit:
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "flexEnd"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        iconType: "cross",
        onClick: setReadOnlyMode,
        "data-test-subj": "prebuilt-rule-upgrade-flyout-field-cancel"
      }, i18n.CANCEL)), /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaSectionErrorBoundary, {
        key: "rule-field-editing-view",
        sectionName: i18n.EDIT_MODE
      }, /*#__PURE__*/_react.default.createElement(_final_edit.FieldFinalEdit, null)));
    default:
      return (0, _utility_types.assertUnreachable)(rightSideMode);
  }
}