"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimestampOverride = exports.ThreatIndicatorPath = exports.Threat = exports.Tags = exports.SeverityMappingItem = exports.RuleNameOverride = exports.RuleAboutSection = exports.RiskScoreMappingItem = exports.RiskScore = exports.References = exports.MaxSignals = exports.License = exports.InvestigationFields = exports.FalsePositives = exports.Description = exports.BuildingBlock = exports.Author = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _zodHelpers = require("@kbn/zod-helpers");
var _severity_badge = require("../../../../common/components/severity_badge");
var _empty_value = require("../../../../common/components/empty_value");
var _helpers = require("../../../rule_creation_ui/pages/rule_creation/helpers");
var _threat_description = require("../../../rule_creation_ui/components/description_step/threat_description");
var _badge_list = require("./badge_list");
var _constants = require("./constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _rule_field_name = require("./rule_field_name");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OverrideColumn = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  width: 125px;
  max-width: 125px;
  overflow: hidden;
  text-overflow: ellipsis;
`;
const OverrideValueColumn = _styledComponents.default.div`
  width: 50px;
  overflow: hidden;
  white-space: nowrap;
  text-overflow: ellipsis;
`;
const StyledEuiLink = (0, _styledComponents.default)(_eui.EuiLink)`
  word-break: break-word;
`;
const Name = ({
  name
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, name);
const Description = ({
  description
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, description);
exports.Description = Description;
const Author = ({
  author
}) => /*#__PURE__*/_react.default.createElement(_badge_list.BadgeList, {
  badges: author,
  "data-test-subj": "authorPropertyValue"
});
exports.Author = Author;
const BuildingBlock = ({
  type
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  "data-test-subj": "buildingBlockPropertyValue"
}, type ? i18n.BUILDING_BLOCK_ENABLED_FIELD_DESCRIPTION : i18n.BUILDING_BLOCK_DISABLED_FIELD_DESCRIPTION);
exports.BuildingBlock = BuildingBlock;
const SeverityMappingItem = ({
  severityMappingItem
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "s"
}, /*#__PURE__*/_react.default.createElement(OverrideColumn, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: severityMappingItem.field,
  "data-test-subj": `severityOverrideField-${severityMappingItem.value}`
}, /*#__PURE__*/_react.default.createElement("span", {
  "data-test-subj": "severityOverrideField"
}, `${severityMappingItem.field}:`))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: severityMappingItem.value,
  "data-test-subj": `severityOverrideValue-${severityMappingItem.value}`
}, /*#__PURE__*/_react.default.createElement(OverrideValueColumn, null, /*#__PURE__*/_react.default.createElement("span", {
  "data-test-subj": "severityOverrideValue"
}, (0, _empty_value.defaultToEmptyTag)(severityMappingItem.value))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: 'sortRight'
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_severity_badge.SeverityBadge, {
  "data-test-subj": "severityOverrideSeverity",
  value: severityMappingItem.severity
})));
exports.SeverityMappingItem = SeverityMappingItem;
const RiskScore = ({
  riskScore
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  "data-test-subj": "riskScorePropertyValue"
}, riskScore);
exports.RiskScore = RiskScore;
const RiskScoreMappingItem = ({
  riskScoreMappingItem
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "s"
}, /*#__PURE__*/_react.default.createElement(OverrideColumn, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: riskScoreMappingItem.field,
  "data-test-subj": `riskScoreOverrideField-${riskScoreMappingItem.value}`
}, /*#__PURE__*/_react.default.createElement("span", {
  "data-test-subj": "riskScoreOverridePropertyFieldName"
}, riskScoreMappingItem.field))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: 'sortRight'
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  "data-test-subj": "riskScoreOverridePropertyOverride"
}, _ruleDataUtils.ALERT_RISK_SCORE));
exports.RiskScoreMappingItem = RiskScoreMappingItem;
const References = ({
  references
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("ul", null, references.filter(reference => !(0, _fp.isEmpty)(reference)).map((reference, index) => /*#__PURE__*/_react.default.createElement("li", {
  "data-test-subj": "urlsDescriptionReferenceLinkItem",
  key: `${index}-${reference}`
}, /*#__PURE__*/_react.default.createElement(StyledEuiLink, {
  href: reference,
  external: true,
  target: "_blank"
}, reference)))));
exports.References = References;
const FalsePositives = ({
  falsePositives
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("ul", null, falsePositives.map(falsePositivesItem => /*#__PURE__*/_react.default.createElement("li", {
  "data-test-subj": "falsePositivesPropertyValueItem",
  key: `falsePositives-${falsePositivesItem}`
}, falsePositivesItem))));
exports.FalsePositives = FalsePositives;
const InvestigationFields = ({
  investigationFields
}) => /*#__PURE__*/_react.default.createElement(_badge_list.BadgeList, {
  badges: investigationFields,
  "data-test-subj": "investigationFieldsPropertyValue"
});
exports.InvestigationFields = InvestigationFields;
const License = ({
  license
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  "data-test-subj": "licensePropertyValue"
}, license);
exports.License = License;
const RuleNameOverride = ({
  ruleNameOverride
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  "data-test-subj": "ruleNameOverridePropertyValue"
}, ruleNameOverride);
exports.RuleNameOverride = RuleNameOverride;
const Threat = ({
  threat
}) => /*#__PURE__*/_react.default.createElement(_threat_description.ThreatEuiFlexGroup, {
  threat: (0, _helpers.filterEmptyThreats)(threat),
  "data-test-subj": "threatPropertyValue"
});
exports.Threat = Threat;
const ThreatIndicatorPath = ({
  threatIndicatorPath
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, threatIndicatorPath);
exports.ThreatIndicatorPath = ThreatIndicatorPath;
const TimestampOverride = ({
  timestampOverride
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  "data-test-subj": "timestampOverridePropertyValue"
}, timestampOverride);
exports.TimestampOverride = TimestampOverride;
const MaxSignals = ({
  maxSignals
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  "data-test-subj": "maxSignalsPropertyValue"
}, maxSignals);
exports.MaxSignals = MaxSignals;
const Tags = ({
  tags
}) => /*#__PURE__*/_react.default.createElement(_badge_list.BadgeList, {
  badges: tags,
  "data-test-subj": "tagsPropertyValue"
});
exports.Tags = Tags;
// eslint-disable-next-line complexity
const prepareAboutSectionListItems = ({
  rule,
  hideName,
  hideDescription
}) => {
  const aboutSectionListItems = [];
  if (!hideName && rule.name) {
    aboutSectionListItems.push({
      title: i18n.NAME_FIELD_LABEL,
      description: /*#__PURE__*/_react.default.createElement(Name, {
        name: rule.name
      })
    });
  }
  if (!hideDescription && rule.description) {
    aboutSectionListItems.push({
      title: i18n.DESCRIPTION_FIELD_LABEL,
      description: /*#__PURE__*/_react.default.createElement(Description, {
        description: rule.description
      })
    });
  }
  if (rule.author && rule.author.length > 0) {
    aboutSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "authorPropertyTitle"
      }, i18n.AUTHOR_FIELD_LABEL),
      description: /*#__PURE__*/_react.default.createElement(Author, {
        author: rule.author
      })
    });
  }
  if (rule.building_block_type) {
    aboutSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "buildingBlockPropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "building_block"
      })),
      description: /*#__PURE__*/_react.default.createElement(BuildingBlock, {
        type: "default"
      })
    });
  }
  if (rule.severity) {
    aboutSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "severityPropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "severity"
      })),
      description: /*#__PURE__*/_react.default.createElement(_severity_badge.SeverityBadge, {
        value: rule.severity,
        "data-test-subj": "severityPropertyValue"
      })
    });
  }
  if (rule.severity_mapping && rule.severity_mapping.length > 0) {
    aboutSectionListItems.push(...rule.severity_mapping.filter(severityMappingItem => severityMappingItem.field !== '').map((severityMappingItem, index) => {
      return {
        title: index === 0 ? /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "severityOverridePropertyTitle"
        }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
          fieldName: "severity_mapping"
        })) : '',
        description: /*#__PURE__*/_react.default.createElement(SeverityMappingItem, {
          severityMappingItem: severityMappingItem
        })
      };
    }));
  }
  if (rule.risk_score) {
    aboutSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "riskScorePropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "risk_score"
      })),
      description: /*#__PURE__*/_react.default.createElement(RiskScore, {
        riskScore: rule.risk_score
      })
    });
  }
  if (rule.risk_score_mapping && rule.risk_score_mapping.length > 0) {
    aboutSectionListItems.push(...rule.risk_score_mapping.filter(riskScoreMappingItem => riskScoreMappingItem.field !== '').map((riskScoreMappingItem, index) => {
      return {
        title: index === 0 ? /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "riskScoreOverridePropertyTitle"
        }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
          fieldName: "risk_score_mapping"
        })) : '',
        description: /*#__PURE__*/_react.default.createElement(RiskScoreMappingItem, {
          riskScoreMappingItem: (0, _zodHelpers.requiredOptional)(riskScoreMappingItem)
        })
      };
    }));
  }
  if (rule.references && rule.references.length > 0) {
    aboutSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "referencesPropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "references"
      })),
      description: /*#__PURE__*/_react.default.createElement(References, {
        references: rule.references
      })
    });
  }
  if (rule.false_positives && rule.false_positives.length > 0) {
    aboutSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "falsePositivesPropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "false_positives"
      })),
      description: /*#__PURE__*/_react.default.createElement(FalsePositives, {
        falsePositives: rule.false_positives
      })
    });
  }
  if (rule.investigation_fields && rule.investigation_fields.field_names.length > 0) {
    aboutSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "investigationFieldsPropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "investigation_fields"
      })),
      description: /*#__PURE__*/_react.default.createElement(InvestigationFields, {
        investigationFields: rule.investigation_fields.field_names
      })
    });
  }
  if (rule.license) {
    aboutSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "licensePropertyTitle"
      }, i18n.LICENSE_FIELD_LABEL),
      description: /*#__PURE__*/_react.default.createElement(License, {
        license: rule.license
      })
    });
  }
  if (rule.rule_name_override) {
    aboutSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "ruleNameOverridePropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "rule_name_override"
      })),
      description: /*#__PURE__*/_react.default.createElement(RuleNameOverride, {
        ruleNameOverride: rule.rule_name_override
      })
    });
  }
  if (rule.threat && rule.threat.length > 0) {
    aboutSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "threatPropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "threat"
      })),
      description: /*#__PURE__*/_react.default.createElement(Threat, {
        threat: rule.threat
      })
    });
  }
  if ('threat_indicator_path' in rule && rule.threat_indicator_path) {
    aboutSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "threatIndicatorPathPropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "threat_indicator_path"
      })),
      description: /*#__PURE__*/_react.default.createElement(ThreatIndicatorPath, {
        threatIndicatorPath: rule.threat_indicator_path
      })
    });
  }
  if (rule.timestamp_override) {
    aboutSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "timestampOverridePropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "timestamp_override"
      })),
      description: /*#__PURE__*/_react.default.createElement(TimestampOverride, {
        timestampOverride: rule.timestamp_override
      })
    });
  }
  if (rule.max_signals) {
    aboutSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "maxSignalsPropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "max_signals"
      })),
      description: /*#__PURE__*/_react.default.createElement(MaxSignals, {
        maxSignals: rule.max_signals
      })
    });
  }
  if (rule.tags && rule.tags.length > 0) {
    aboutSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "tagsPropertyTitle"
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "tags"
      })),
      description: /*#__PURE__*/_react.default.createElement(Tags, {
        tags: rule.tags
      })
    });
  }
  return aboutSectionListItems;
};
const RuleAboutSection = ({
  rule,
  columnWidths = _constants.DEFAULT_DESCRIPTION_LIST_COLUMN_WIDTHS,
  hideName,
  hideDescription,
  ...descriptionListProps
}) => {
  var _descriptionListProps, _descriptionListProps2;
  const aboutSectionListItems = prepareAboutSectionListItems({
    rule,
    hideName,
    hideDescription
  });
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, (0, _extends2.default)({
    type: (_descriptionListProps = descriptionListProps.type) !== null && _descriptionListProps !== void 0 ? _descriptionListProps : 'column',
    rowGutterSize: (_descriptionListProps2 = descriptionListProps.rowGutterSize) !== null && _descriptionListProps2 !== void 0 ? _descriptionListProps2 : 'm',
    listItems: aboutSectionListItems,
    columnWidths: columnWidths,
    "data-test-subj": "listItemColumnStepRuleDescription"
  }, descriptionListProps)));
};
exports.RuleAboutSection = RuleAboutSection;