"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BadgeList = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiBadge = (0, _styledComponents.default)(_eui.EuiBadge)`
  .euiBadge__text {
    white-space: pre-wrap !important;
  }
`;
const BadgeList = ({
  badges,
  'data-test-subj': dataTestSubj
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  responsive: false,
  gutterSize: "xs",
  wrap: true,
  "data-test-subj": dataTestSubj
}, badges.map(badge => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  key: `badge-${badge}`,
  "data-test-subj": `${dataTestSubj}Item`
}, /*#__PURE__*/_react.default.createElement(StyledEuiBadge, {
  color: "hollow"
}, badge))));
exports.BadgeList = BadgeList;