"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGapRange = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getGapRange = gapRange => {
  const now = (0, _moment.default)();
  let duration;
  switch (gapRange) {
    case _constants.GapRangeValue.LAST_24_H:
      duration = _moment.default.duration(24, 'hours');
      break;
    case _constants.GapRangeValue.LAST_3_D:
      duration = _moment.default.duration(3, 'days');
      break;
    case _constants.GapRangeValue.LAST_7_D:
      duration = _moment.default.duration(7, 'days');
      break;
  }
  const start = now.clone().subtract(duration).toISOString();
  const end = now.toISOString();
  return {
    start,
    end
  };
};
exports.getGapRange = getGapRange;