"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomHeaderPageMemo = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _header_page = require("../../../common/components/header_page");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CustomHeaderPage = ({
  backOptions,
  isLoading,
  title,
  togglePanel,
  isRulePreviewVisible,
  setIsRulePreviewVisible
}) => /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
  backOptions: backOptions,
  isLoading: isLoading,
  title: title
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  "data-test-subj": "preview-container",
  isSelected: isRulePreviewVisible,
  fill: isRulePreviewVisible,
  iconType: "visBarVerticalStacked",
  onClick: () => {
    togglePanel === null || togglePanel === void 0 ? void 0 : togglePanel('preview', {
      direction: 'left'
    });
    setIsRulePreviewVisible(isVisible => !isVisible);
  }
}, i18n.RULE_PREVIEW_TITLE));
const CustomHeaderPageMemo = exports.CustomHeaderPageMemo = /*#__PURE__*/(0, _react.memo)(CustomHeaderPage);