"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPreviewTableControlColumn = exports.PreviewActions = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _header_actions = require("../../../../common/components/header_actions");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EventsTdContent = _styledComponents.default.div.attrs(({
  className
}) => ({
  className: `siemEventsTable__tdContent ${className != null ? className : ''}`
}))`
  font-size: ${({
  theme
}) => theme.eui.euiFontSizeXS};
  line-height: ${({
  theme
}) => theme.eui.euiLineHeight};
  min-width: 0;
  padding: ${({
  theme
}) => theme.eui.euiSizeXS};
  text-align: ${({
  textAlign
}) => textAlign};
  width: ${({
  width
}) => width != null ? `${width}px` : '100%'}; /* Using width: 100% instead of flex: 1 and max-width: 100% for IE11 */

  button.euiButtonIcon {
    margin-left: ${({
  theme
}) => `-${theme.eui.euiSizeXS}`};
  }
`;
const getPreviewTableControlColumn = actionButtonCount => [{
  headerCellRender: () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.ACTIONS),
  id: 'default-timeline-control-column',
  rowCellRender: PreviewActions,
  width: (0, _header_actions.getActionsColumnWidth)(actionButtonCount)
}];
exports.getPreviewTableControlColumn = getPreviewTableControlColumn;
const ActionsContainer = _styledComponents.default.div`
  align-items: center;
  display: flex;
`;
const PreviewActionsComponent = ({
  ariaRowindex,
  columnValues,
  onEventDetailsPanelOpened
}) => {
  return /*#__PURE__*/_react.default.createElement(ActionsContainer, null, /*#__PURE__*/_react.default.createElement("div", {
    key: "expand-event"
  }, /*#__PURE__*/_react.default.createElement(EventsTdContent, {
    textAlign: "center",
    width: _header_actions.DEFAULT_ACTION_BUTTON_WIDTH + 10
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": "expand-event-tool-tip",
    content: i18n.VIEW_DETAILS
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": i18n.VIEW_DETAILS_FOR_ROW({
      ariaRowindex,
      columnValues
    }),
    "data-test-subj": "expand-event",
    iconType: "expand",
    onClick: onEventDetailsPanelOpened,
    size: "s"
  })))));
};
PreviewActionsComponent.displayName = 'PreviewActionsComponent';
const PreviewActions = exports.PreviewActions = /*#__PURE__*/_react.default.memo(PreviewActionsComponent);