"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreviewRenderCellValue = void 0;
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _model = require("../../../../sourcerer/store/model");
var _security_solution_detections = require("../../../../detections/configurations/security_solution_detections");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const emptyUserProfiles = {
  profiles: [],
  isLoading: false
};
const PreviewRenderCellValue = ({
  data,
  ecsData,
  setCellProps,
  isExpandable,
  isExpanded,
  isDetails,
  rowIndex,
  colIndex,
  columnId,
  rowRenderers,
  truncate
}) => {
  const legacyAlert = (0, _react.useMemo)(() => data !== null && data !== void 0 ? data : [], [data]);
  return /*#__PURE__*/_react.default.createElement(_security_solution_detections.CellValue, {
    tableType: _securitysolutionDataTable.TableId.rulePreview,
    sourcererScope: _model.SourcererScopeName.detections,
    legacyAlert: legacyAlert,
    ecsAlert: ecsData,
    asPlainText: true,
    setCellProps: setCellProps,
    isExpandable: isExpandable,
    isExpanded: isExpanded,
    isDetails: isDetails,
    rowIndex: rowIndex,
    colIndex: colIndex,
    columnId: columnId,
    rowRenderers: rowRenderers,
    truncate: truncate,
    userProfiles: emptyUserProfiles
  });
};
exports.PreviewRenderCellValue = PreviewRenderCellValue;