"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadingHistogram = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var i18n = _interopRequireWildcard(require("./translations"));
var _panel = require("../../../../common/components/panel");
var _header_section = require("../../../../common/components/header_section");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LoadingChart = (0, _styledComponents.default)(_eui.EuiLoadingChart)`
  display: block;
  margin: 0 auto;
`;
const DEFAULT_HISTOGRAM_HEIGHT = 300;
const LoadingHistogram = () => {
  return /*#__PURE__*/_react.default.createElement(_panel.Panel, {
    height: DEFAULT_HISTOGRAM_HEIGHT,
    "data-test-subj": 'preview-histogram-panel'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    title: i18n.QUERY_GRAPH_HITS_TITLE,
    titleSize: "xs",
    subtitle: 'loading'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(LoadingChart, {
    size: "l",
    "data-test-subj": "preview-histogram-loading"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)));
};
exports.LoadingHistogram = LoadingHistogram;