"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.esqlValidationErrorMessage = exports.ESQL_VALIDATION_UNKNOWN_ERROR = exports.ESQL_VALIDATION_MISSING_METADATA_OPERATOR_IN_QUERY_ERROR = exports.ESQL_VALIDATION_MISSING_ID_FIELD_IN_QUERY_ERROR = exports.ESQL_QUERY_VALIDATION_REQUIRED = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ESQL_QUERY_VALIDATION_REQUIRED = exports.ESQL_QUERY_VALIDATION_REQUIRED = _i18n.i18n.translate('xpack.securitySolution.ruleManagement.esqlValidation.requiredError', {
  defaultMessage: 'An ES|QL query is required.'
});
const ESQL_VALIDATION_UNKNOWN_ERROR = exports.ESQL_VALIDATION_UNKNOWN_ERROR = _i18n.i18n.translate('xpack.securitySolution.ruleManagement.esqlValidation.unknownError', {
  defaultMessage: 'Unknown error while validating ES|QL'
});
const esqlValidationErrorMessage = message => _i18n.i18n.translate('xpack.securitySolution.ruleManagement.esqlValidation.errorMessage', {
  values: {
    message
  },
  defaultMessage: 'Error validating ES|QL: "{message}"'
});
exports.esqlValidationErrorMessage = esqlValidationErrorMessage;
const ESQL_VALIDATION_MISSING_METADATA_OPERATOR_IN_QUERY_ERROR = exports.ESQL_VALIDATION_MISSING_METADATA_OPERATOR_IN_QUERY_ERROR = _i18n.i18n.translate('xpack.securitySolution.ruleManagement.esqlValidation.missingMetadataOperatorInQueryError', {
  defaultMessage: `Queries that don’t use the STATS...BY function (non-aggregating queries) must include the "metadata _id, _version, _index" operator after the source command. For example: FROM logs* metadata _id, _version, _index.`
});
const ESQL_VALIDATION_MISSING_ID_FIELD_IN_QUERY_ERROR = exports.ESQL_VALIDATION_MISSING_ID_FIELD_IN_QUERY_ERROR = _i18n.i18n.translate('xpack.securitySolution.ruleManagement.esqlValidation.missingIdFieldInQueryError', {
  defaultMessage: `Queries that don’t use the STATS...BY function (non-aggregating queries) must include the "metadata _id, _version, _index" operator after the source command. For example: FROM logs* metadata _id, _version, _index.  In addition, the metadata properties (_id, _version, and _index)  must be returned in the query response.`
});