"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTrailingBreadcrumbs = void 0;
var _use_rule_details_tabs = require("../rule_details_ui/pages/rule_details/use_rule_details_tabs");
var _redirect_to_detection_engine = require("../../common/components/link_to/redirect_to_detection_engine");
var i18nRules = _interopRequireWildcard(require("./translations"));
var _types = require("../../app/types");
var _constants = require("../../../common/constants");
var _translations2 = require("../rule_details_ui/pages/rule_details/translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRuleDetailsTabName = tabName => {
  var _RULE_DETAILS_TAB_NAM;
  return (_RULE_DETAILS_TAB_NAM = _use_rule_details_tabs.RULE_DETAILS_TAB_NAME[tabName]) !== null && _RULE_DETAILS_TAB_NAM !== void 0 ? _RULE_DETAILS_TAB_NAM : _use_rule_details_tabs.RULE_DETAILS_TAB_NAME[_use_rule_details_tabs.RuleDetailTabs.alerts];
};
const isRuleCreatePage = pathname => pathname.includes(_constants.RULES_PATH) && pathname.includes('/create');
const isRuleEditPage = pathname => pathname.includes(_constants.RULES_PATH) && pathname.includes('/edit');

/**
 * This module should only export this function.
 * All the `getTrailingBreadcrumbs` functions in Security are loaded into the main bundle.
 * We should be careful to not import unnecessary modules in this file to avoid increasing the main app bundle size.
 */
const getTrailingBreadcrumbs = (params, getSecuritySolutionUrl) => {
  var _params$state, _params$state2, _params$state3;
  let breadcrumb = [];
  if (params.detailName && (_params$state = params.state) !== null && _params$state !== void 0 && _params$state.ruleName) {
    breadcrumb = [...breadcrumb, {
      text: params.state.ruleName,
      href: getSecuritySolutionUrl({
        deepLinkId: _types.SecurityPageName.rules,
        path: (0, _redirect_to_detection_engine.getRuleDetailsUrl)(params.detailName, '')
      })
    }];
  }
  if (params.detailName && (_params$state2 = params.state) !== null && _params$state2 !== void 0 && _params$state2.ruleName && params.tabName) {
    breadcrumb = [...breadcrumb, {
      text: getRuleDetailsTabName(params.tabName),
      href: getSecuritySolutionUrl({
        deepLinkId: _types.SecurityPageName.rules,
        path: (0, _redirect_to_detection_engine.getRuleDetailsTabUrl)(params.detailName, params.tabName, '')
      })
    }];
  }
  if (isRuleCreatePage(params.pathName)) {
    breadcrumb = [...breadcrumb, {
      text: i18nRules.ADD_PAGE_TITLE,
      href: ''
    }];
  }
  if (isRuleEditPage(params.pathName) && params.detailName && (_params$state3 = params.state) !== null && _params$state3 !== void 0 && _params$state3.ruleName) {
    breadcrumb = [...breadcrumb, {
      text: i18nRules.EDIT_PAGE_TITLE,
      href: ''
    }];
  }
  if (!isRuleEditPage(params.pathName) && params.state && !params.state.isExistingRule) {
    breadcrumb = [...breadcrumb, {
      text: _translations2.DELETED_RULE,
      href: ''
    }];
  }
  return breadcrumb;
};
exports.getTrailingBreadcrumbs = getTrailingBreadcrumbs;