"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDefaultDataView = void 0;
var _model = require("../../sourcerer/store/model");
var _create_sourcerer_data_view = require("../../sourcerer/containers/create_sourcerer_data_view");
var _constants = require("../../../common/constants");
var _helpers_access = require("../../helpers_access");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createDefaultDataView = async ({
  uiSettings,
  dataViewService,
  spaces,
  skip,
  http,
  application
}) => {
  const configPatternList = uiSettings.get(_constants.DEFAULT_INDEX_KEY);
  let defaultDataView;
  let alertDataView;
  let kibanaDataViews;
  let signal = {
    name: null,
    index_mapping_outdated: null
  };
  if (skip) {
    return {
      kibanaDataViews: [],
      defaultDataView: {
        ..._model.initDataView
      },
      alertDataView: {
        ..._model.initDataView
      },
      signal
    };
  }
  try {
    var _await$spaces$getActi, _await$spaces$getActi2, _signal$name;
    if ((0, _helpers_access.hasAccessToSecuritySolution)(application.capabilities)) {
      signal = await http.fetch(_constants.DETECTION_ENGINE_INDEX_URL, {
        version: '2023-10-31',
        method: 'GET'
      });
    }

    // check for/generate default Security Solution Kibana data view
    const sourcererDataView = await (0, _create_sourcerer_data_view.createSourcererDataView)({
      body: {
        patternList: [...configPatternList, ...(signal.name != null ? [signal.name] : [])]
      },
      dataViewService,
      dataViewId: `${_constants.DEFAULT_DATA_VIEW_ID}-${(_await$spaces$getActi = await (spaces === null || spaces === void 0 ? void 0 : spaces.getActiveSpace())) === null || _await$spaces$getActi === void 0 ? void 0 : _await$spaces$getActi.id}`,
      alertDataViewId: `${_constants.DEFAULT_ALERT_DATA_VIEW_ID}-${(_await$spaces$getActi2 = await (spaces === null || spaces === void 0 ? void 0 : spaces.getActiveSpace())) === null || _await$spaces$getActi2 === void 0 ? void 0 : _await$spaces$getActi2.id}`,
      signalIndexName: (_signal$name = signal.name) !== null && _signal$name !== void 0 ? _signal$name : undefined
    });
    if (sourcererDataView === undefined) {
      throw new Error('');
    }
    defaultDataView = {
      ..._model.initDataView,
      ...sourcererDataView.defaultDataView
    };
    alertDataView = {
      ..._model.initDataView,
      ...sourcererDataView.alertDataView
    };
    kibanaDataViews = sourcererDataView.kibanaDataViews.map(dataView => ({
      ..._model.initDataView,
      ...dataView
    }));
  } catch (error) {
    defaultDataView = {
      ..._model.initDataView,
      error
    };
    alertDataView = {
      ..._model.initDataView,
      error
    };
    kibanaDataViews = [];
  }
  return {
    kibanaDataViews,
    defaultDataView,
    alertDataView,
    signal
  };
};
exports.createDefaultDataView = createDefaultDataView;