"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildBrowserFields = void 0;
var _helpers = require("@kbn/response-ops-alerts-fields-browser/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// NOTE:for referential comparison optimization
const emptyBrowserFields = {};

/**
 * Browser fields are simply an object with category names as keys and each category has a fields object
 * The purpose of this shape is simply to power the custom field browser experience in the Security UI,
 * specifically seen in the Alerts Page and Explore Pages.
 * IF YOU NEED TO ACCESS FIELDS DIRECTLY FOR FUNCTIONALITY, PLEASE USE THE DATA VIEW FIELDS DIRECTLY.
 */

const buildBrowserFields = fields => {
  if (fields == null || !fields.length) return emptyBrowserFields;
  const browserFields = {};
  for (let i = 0; i < fields.length; i++) {
    const field = fields[i].spec;
    const name = field.name;
    if (name != null) {
      const category = (0, _helpers.getCategory)(name);
      if (browserFields[category] == null) {
        browserFields[category] = {
          fields: {}
        };
      }
      const categoryFields = browserFields[category].fields;
      if (categoryFields) {
        categoryFields[name] = field;
      }
    }
  }
  return browserFields;
};
exports.buildBrowserFields = buildBrowserFields;