"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scopes = exports.initialDataViewManagerState = exports.dataViewManagerReducer = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _constants = require("../constants");
var _slices = require("./slices");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Define registered scopes array.
 */
const REGISTERED_SCOPES = [_constants.DataViewManagerScopeName.default, _constants.DataViewManagerScopeName.timeline, _constants.DataViewManagerScopeName.detections, _constants.DataViewManagerScopeName.analyzer, _constants.DataViewManagerScopeName.explore];

/**
 * Helper function to create objects with Registered Scope names as keys
 */
const createScopeMap = valueCreator => {
  return REGISTERED_SCOPES.reduce((acc, scopeName) => {
    acc[scopeName] = valueCreator(scopeName);
    return acc;
  }, {});
};

/*
 * Create scopes object
 */
const scopes = exports.scopes = createScopeMap(_slices.createDataViewSelectionSlice);

/**
 * Create DataViewManager reducer
 */
const dataViewManagerReducer = exports.dataViewManagerReducer = (0, _toolkit.combineReducers)({
  ...createScopeMap(scopeName => scopes[scopeName].reducer),
  shared: _slices.sharedDataViewManagerSlice.reducer
});
/**
 * Create initial state
 */
const initialDataViewManagerState = exports.initialDataViewManagerState = {
  dataViewManager: {
    ...createScopeMap(() => _slices.initialScopeState),
    shared: _slices.initialSharedState
  }
};