"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewPicker = void 0;
var _public = require("@kbn/unified-search-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _public2 = require("@kbn/data-views-plugin/public");
var _constants = require("../../../../common/constants");
var _global_query_string = require("../../../common/utils/global_query_string");
var _use_url_state = require("../../../common/hooks/use_url_state");
var _kibana = require("../../../common/lib/kibana");
var _selectors = require("../../redux/selectors");
var _slices = require("../../redux/slices");
var _use_select_data_view = require("../../hooks/use_select_data_view");
var _constants2 = require("../../constants");
var _use_managed_data_views = require("../../hooks/use_managed_data_views");
var _use_saved_data_views = require("../../hooks/use_saved_data_views");
var _translations = require("./translations");
var _constants3 = require("./constants");
var _use_data_view = require("../../hooks/use_data_view");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataViewPicker = exports.DataViewPicker = /*#__PURE__*/(0, _react.memo)(({
  scope,
  onClosePopover,
  disabled
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const selectDataView = (0, _use_select_data_view.useSelectDataView)();
  const {
    services: {
      dataViewEditor,
      data,
      dataViewFieldEditor,
      fieldFormats
    }
  } = (0, _kibana.useKibana)();
  const canEditDataView = (0, _react.useMemo)(() => Boolean(dataViewEditor === null || dataViewEditor === void 0 ? void 0 : dataViewEditor.userPermissions.editDataView()), [dataViewEditor]);
  const closeDataViewEditor = (0, _react.useRef)();
  const closeFieldEditor = (0, _react.useRef)();
  const {
    dataView,
    status
  } = (0, _use_data_view.useDataView)(scope);
  const {
    adhocDataViews: adhocDataViewSpecs,
    defaultDataViewId
  } = (0, _reactRedux.useSelector)(_selectors.sharedStateSelector);
  const adhocDataViews = (0, _react.useMemo)(() => {
    return adhocDataViewSpecs.filter(spec => {
      var _spec$id;
      return !((_spec$id = spec.id) !== null && _spec$id !== void 0 && _spec$id.startsWith(_constants.EXPLORE_DATA_VIEW_PREFIX));
    }).map(spec => new _public2.DataView({
      spec,
      fieldFormats
    }));
  }, [adhocDataViewSpecs, fieldFormats]);
  const managedDataViews = (0, _use_managed_data_views.useManagedDataViews)();
  const savedDataViews = (0, _use_saved_data_views.useSavedDataViews)();
  const isDefaultSourcerer = scope === _constants2.DataViewManagerScopeName.default;
  const updateUrlParam = (0, _global_query_string.useUpdateUrlParam)(_use_url_state.URL_PARAM_KEY.sourcerer);
  const dataViewId = dataView === null || dataView === void 0 ? void 0 : dataView.id;

  // NOTE: this function is called in response to user interaction with the picker,
  // hence - it is the only place where we should update the url param for the data view selection.
  const handleChangeDataView = (0, _react.useCallback)((id, indexPattern = '') => {
    selectDataView({
      id,
      scope
    });
    if (isDefaultSourcerer) {
      updateUrlParam({
        [_constants2.DataViewManagerScopeName.default]: {
          id,
          // NOTE: Boolean filter for removing empty patterns
          selectedPatterns: indexPattern.split(',').filter(Boolean)
        }
      });
    }
  }, [isDefaultSourcerer, scope, selectDataView, updateUrlParam]);
  const createNewDataView = (0, _react.useCallback)(() => {
    closeDataViewEditor.current = dataViewEditor.openEditor({
      onSave: async newDataView => {
        if (!newDataView.id) {
          return;
        }
        dispatch(_slices.sharedDataViewManagerSlice.actions.addDataView(newDataView));
        handleChangeDataView(newDataView.id, newDataView.getIndexPattern());
      },
      allowAdHocDataView: true
    });
  }, [dataViewEditor, dispatch, handleChangeDataView]);
  const editField = (0, _react.useCallback)(async (fieldName, _uiAction = 'edit') => {
    if (!dataViewId) {
      return;
    }
    const dataViewInstance = await data.dataViews.get(dataViewId);
    // Modifications to the fields do not trigger cache invalidation, but should as `fields` will be stale.
    data.dataViews.clearInstanceCache(dataViewId);
    closeFieldEditor.current = await dataViewFieldEditor.openEditor({
      ctx: {
        dataView: dataViewInstance
      },
      fieldName,
      onSave: async () => {
        if (!dataViewInstance.id) {
          return;
        }
        handleChangeDataView(dataViewInstance.id, dataViewInstance.getIndexPattern());
      }
    });
  }, [dataViewId, data.dataViews, dataViewFieldEditor, handleChangeDataView]);

  /**
   * Selects data view again. After changes are made to the data view, this results in cache invalidation and will force the reload everywhere.
   */
  const handleDataViewModified = (0, _react.useMemo)(() => {
    if (!canEditDataView) {
      return undefined;
    }
    return updatedDataView => {
      if (!updatedDataView.id) {
        return;
      }
      handleChangeDataView(updatedDataView.id, updatedDataView.getIndexPattern());
    };
  }, [canEditDataView, handleChangeDataView]);
  const handleAddField = (0, _react.useMemo)(() => canEditDataView ? () => editField(undefined, 'add') : undefined, [editField, canEditDataView]);
  const triggerConfig = (0, _react.useMemo)(() => {
    if (status === 'loading') {
      return {
        label: _translations.LOADING
      };
    }
    if ((dataView === null || dataView === void 0 ? void 0 : dataView.id) === defaultDataViewId) {
      return {
        label: _translations.DEFAULT_SECURITY_DATA_VIEW
      };
    }
    return {
      label: (dataView === null || dataView === void 0 ? void 0 : dataView.name) || (dataView === null || dataView === void 0 ? void 0 : dataView.id) || 'Data view'
    };
  }, [dataView === null || dataView === void 0 ? void 0 : dataView.id, dataView === null || dataView === void 0 ? void 0 : dataView.name, defaultDataViewId, status]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _constants3.DATA_VIEW_PICKER_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_public.DataViewPicker, {
    isDisabled: status !== 'ready' || disabled,
    currentDataViewId: dataViewId || (defaultDataViewId !== null && defaultDataViewId !== void 0 ? defaultDataViewId : undefined),
    trigger: triggerConfig,
    onChangeDataView: handleChangeDataView,
    onEditDataView: handleDataViewModified,
    onAddField: handleAddField,
    onDataViewCreated: createNewDataView,
    adHocDataViews: adhocDataViews,
    savedDataViews: savedDataViews,
    managedDataViews: managedDataViews,
    onClosePopover: onClosePopover
  }));
});
DataViewPicker.displayName = 'DataviewPicker';