"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAgentTypeName = exports.UPGRADE_AGENT_FOR_RESPONDER = exports.UPDATE_ALERT_STATUS_FAILED_DETAILED = exports.UPDATE_ALERT_STATUS_FAILED = exports.UNSAVED_TIMELINE_SAVE_PROMPT_TITLE = exports.UNSAVED_TIMELINE_SAVE_PROMPT = exports.TECHNICAL_PREVIEW_TOOLTIP = exports.TECHNICAL_PREVIEW = exports.SOLUTION_NAME = exports.RULE_EXECUTION_TYPE_STANDARD = exports.RULE_EXECUTION_TYPE_BACKFILL = exports.INSUFFICIENT_PRIVILEGES_FOR_COMMAND = exports.BETA_TOOLTIP = exports.BETA = exports.ASSISTANT_MANAGEMENT_TITLE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SOLUTION_NAME = exports.SOLUTION_NAME = _i18n.i18n.translate('xpack.securitySolution.pages.common.solutionName', {
  defaultMessage: 'Security'
});
const ASSISTANT_MANAGEMENT_TITLE = exports.ASSISTANT_MANAGEMENT_TITLE = _i18n.i18n.translate('xpack.securitySolution.securityAiAssistantManagement.app.title', {
  defaultMessage: 'AI Assistant for Security'
});
const BETA = exports.BETA = _i18n.i18n.translate('xpack.securitySolution.pages.common.beta', {
  defaultMessage: 'Beta'
});
const BETA_TOOLTIP = exports.BETA_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.pages.common.beta.tooltip', {
  defaultMessage: 'This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.'
});
const TECHNICAL_PREVIEW = exports.TECHNICAL_PREVIEW = _i18n.i18n.translate('xpack.securitySolution.pages.common.technicalPreviewLabel', {
  defaultMessage: 'Technical Preview'
});
const TECHNICAL_PREVIEW_TOOLTIP = exports.TECHNICAL_PREVIEW_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.pages.common.technicalPreviewTooltip', {
  defaultMessage: 'This functionality is in technical preview and may be changed or removed completely in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.'
});
const UPDATE_ALERT_STATUS_FAILED = conflicts => _i18n.i18n.translate('xpack.securitySolution.pages.common.updateAlertStatusFailed', {
  values: {
    conflicts
  },
  defaultMessage: 'Failed to update { conflicts } {conflicts, plural, =1 {alert} other {alerts}}.'
});
exports.UPDATE_ALERT_STATUS_FAILED = UPDATE_ALERT_STATUS_FAILED;
const UPDATE_ALERT_STATUS_FAILED_DETAILED = (updated, conflicts) => _i18n.i18n.translate('xpack.securitySolution.pages.common.updateAlertStatusFailedDetailed', {
  values: {
    updated,
    conflicts
  },
  defaultMessage: `{ updated } {updated, plural, =1 {alert was} other {alerts were}} updated successfully, but { conflicts } failed to update
         because { conflicts, plural, =1 {it was} other {they were}} already being modified.`
});
exports.UPDATE_ALERT_STATUS_FAILED_DETAILED = UPDATE_ALERT_STATUS_FAILED_DETAILED;
const UPGRADE_AGENT_FOR_RESPONDER = (_agentType, command) => {
  const agentType = getAgentTypeName(_agentType);
  if (_agentType === 'endpoint') {
    return _i18n.i18n.translate('xpack.securitySolution.endpoint.actions.unsupported.message', {
      defaultMessage: `The current version of the {agentType} Agent does not support {command}. Upgrade your Elastic Agent through Fleet to the latest version to enable this response action.`,
      values: {
        agentType,
        command
      }
    });
  }
  return _i18n.i18n.translate('xpack.securitySolution.agent.actions.unsupported.message', {
    defaultMessage: `Support for {command} is not currently available for {agentType}.`,
    values: {
      agentType,
      command
    }
  });
};
exports.UPGRADE_AGENT_FOR_RESPONDER = UPGRADE_AGENT_FOR_RESPONDER;
const INSUFFICIENT_PRIVILEGES_FOR_COMMAND = exports.INSUFFICIENT_PRIVILEGES_FOR_COMMAND = _i18n.i18n.translate('xpack.securitySolution.endpoint.actions.insufficientPrivileges.error', {
  defaultMessage: 'You do not have sufficient privileges to use this command. Please contact your administrator for access.'
});
const UNSAVED_TIMELINE_SAVE_PROMPT = exports.UNSAVED_TIMELINE_SAVE_PROMPT = _i18n.i18n.translate('xpack.securitySolution.timeline.unsavedWorkMessage', {
  defaultMessage: 'Leave Timeline with unsaved work?'
});
const UNSAVED_TIMELINE_SAVE_PROMPT_TITLE = exports.UNSAVED_TIMELINE_SAVE_PROMPT_TITLE = _i18n.i18n.translate('xpack.securitySolution.timeline.unsavedWorkTitle', {
  defaultMessage: 'Unsaved changes'
});
const getAgentTypeName = agentType => {
  switch (agentType) {
    case 'endpoint':
      return 'Elastic Defend';
    case 'sentinel_one':
      return 'SentinelOne';
    case 'crowdstrike':
      return 'Crowdstrike';
    case 'microsoft_defender_endpoint':
      return 'Microsoft Defender for Endpoint';
    default:
      return agentType;
  }
};
exports.getAgentTypeName = getAgentTypeName;
const RULE_EXECUTION_TYPE_BACKFILL = exports.RULE_EXECUTION_TYPE_BACKFILL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.executionRunType.backfill', {
  defaultMessage: 'Manual'
});
const RULE_EXECUTION_TYPE_STANDARD = exports.RULE_EXECUTION_TYPE_STANDARD = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.executionRunType.standard', {
  defaultMessage: 'Scheduled'
});