"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MissingPrivilegesTooltip = exports.MissingPrivilegesDescription = exports.MissingPrivilegesCallOut = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MissingPrivilegesDescription = exports.MissingPrivilegesDescription = /*#__PURE__*/_react.default.memo(({
  privileges
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column",
    "data-test-subj": "missingPrivilegesGroup"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, i18n.PRIVILEGES_REQUIRED_TITLE), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, /*#__PURE__*/_react.default.createElement("ul", null, privileges.map(privilege => /*#__PURE__*/_react.default.createElement("li", {
    key: privilege
  }, privilege))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, i18n.CONTACT_ADMINISTRATOR));
});
MissingPrivilegesDescription.displayName = 'MissingPrivilegesDescription';
const anchorProps = {
  style: {
    width: 'fit-content'
  },
  'data-test-subj': 'missingPrivilegesTooltipAnchor'
};
const MissingPrivilegesTooltip = exports.MissingPrivilegesTooltip = /*#__PURE__*/_react.default.memo(({
  children,
  description
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  "data-test-subj": "missingPrivilegesTooltip",
  anchorProps: anchorProps,
  title: i18n.PRIVILEGES_MISSING_TITLE,
  content: description
}, children));
MissingPrivilegesTooltip.displayName = 'MissingPrivilegesTooltip';
const MissingPrivilegesCallOut = exports.MissingPrivilegesCallOut = /*#__PURE__*/_react.default.memo(({
  children
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const calloutCss = (0, _react2.css)`
    border-radius: ${euiTheme.border.radius.small};
    border: 1px solid ${euiTheme.colors.borderBaseSubdued};
  `;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.PRIVILEGES_MISSING_TITLE,
    iconType: "info",
    css: calloutCss
  }, children);
});
MissingPrivilegesCallOut.displayName = 'MissingPrivilegesCallOut';