"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useValueChanged = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Use this method to watch value for changes.
 *
 * CAUTION: you probably don't need this hook. Try to use useEffect first.
 * It is only useful in rare cases when a value differs by reference but not by content between renders.
 *
 * @param callback A callback to call when the value changes
 * @param nextValue A value to observe for changes
 */
const useValueChanged = (callback, nextValue) => {
  const prevValue = (0, _react.useRef)(nextValue);
  (0, _react.useEffect)(() => {
    if (JSON.stringify(prevValue.current) !== JSON.stringify(nextValue)) {
      prevValue.current = nextValue;
      callback(nextValue);
    }
  }, [callback, nextValue]);
};
exports.useValueChanged = useValueChanged;