"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateExecutionContext = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _kibana = require("../lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUpdateExecutionContext = () => {
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const {
    executionContext
  } = (0, _kibana.useKibana)().services;
  (0, _react.useEffect)(() => {
    // setImmediate is required to ensure that EBT telemetry for the previous page is shipped before the new page is updated
    setImmediate(() => {
      executionContext.set({
        page: pathname
      });
    });
  }, [pathname, executionContext]);
};
exports.useUpdateExecutionContext = useUpdateExecutionContext;