"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetFieldSpec = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _model = require("../../sourcerer/store/model");
var _store = require("../../sourcerer/store");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetFieldSpec = scopeId => {
  const kibanaDataViews = (0, _reactRedux.useSelector)(_store.sourcererSelectors.kibanaDataViews);
  const scopedDataViewId = (0, _reactRedux.useSelector)(state => _store.sourcererSelectors.sourcererScopeSelectedDataViewId(state, scopeId));
  const scopedDataView = (0, _react.useMemo)(() => kibanaDataViews.find(dv => dv.id === scopedDataViewId), [kibanaDataViews, scopedDataViewId]);

  // we retrieve the default data view to be used in Timeline for some specific situations
  const fallbackDefaultDataViewId = (0, _reactRedux.useSelector)(state => _store.sourcererSelectors.sourcererScopeSelectedDataViewId(state, _model.SourcererScopeName.default));
  const fallbackDefaultDataView = (0, _react.useMemo)(() => kibanaDataViews.find(dv => dv.id === fallbackDefaultDataViewId), [fallbackDefaultDataViewId, kibanaDataViews]);

  // for Threshold, New Terms and Suppressed Timelines, when users click on Investigate in Timeline, the dataView is undefined.
  // Falling back to the default dataView makes the cell actions working
  const dataView = (0, _react.useMemo)(() => !scopedDataView && scopeId === _model.SourcererScopeName.timeline ? fallbackDefaultDataView : scopedDataView, [fallbackDefaultDataView, scopeId, scopedDataView]);
  return (0, _react.useCallback)(fieldName => {
    const fields = dataView === null || dataView === void 0 ? void 0 : dataView.fields;
    return fields && fields[fieldName];
  }, [dataView === null || dataView === void 0 ? void 0 : dataView.fields]);
};
exports.useGetFieldSpec = useGetFieldSpec;