"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSyncTimelineUrlParam = void 0;
var _react = require("react");
var _global_query_string = require("../../utils/global_query_string");
var _store = require("../../../timelines/store");
var _types = require("../../../../common/types");
var _use_selector = require("../use_selector");
var _use_url_state = require("../use_url_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSyncTimelineUrlParam = () => {
  const updateUrlParam = (0, _global_query_string.useUpdateUrlParam)(_use_url_state.URL_PARAM_KEY.timeline);
  const getTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getTimelineByIdSelector(), []);
  const {
    activeTab,
    graphEventId,
    show,
    savedObjectId,
    savedSearchId,
    kqlQuery
  } = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getTimeline;
    return (_getTimeline = getTimeline(state, _types.TimelineId.active)) !== null && _getTimeline !== void 0 ? _getTimeline : {};
  });
  (0, _react.useEffect)(() => {
    var _kqlQuery$filterQuery, _kqlQuery$filterQuery2, _kqlQuery$filterQuery3, _kqlQuery$filterQuery4, _kqlQuery$filterQuery5, _kqlQuery$filterQuery6;
    const params = {
      ...(savedObjectId ? {
        id: savedObjectId
      } : {}),
      isOpen: show,
      activeTab,
      graphEventId: graphEventId !== null && graphEventId !== void 0 ? graphEventId : '',
      savedSearchId: savedSearchId ? savedSearchId : undefined,
      query: {
        kind: (_kqlQuery$filterQuery = kqlQuery === null || kqlQuery === void 0 ? void 0 : (_kqlQuery$filterQuery2 = kqlQuery.filterQuery) === null || _kqlQuery$filterQuery2 === void 0 ? void 0 : (_kqlQuery$filterQuery3 = _kqlQuery$filterQuery2.kuery) === null || _kqlQuery$filterQuery3 === void 0 ? void 0 : _kqlQuery$filterQuery3.kind) !== null && _kqlQuery$filterQuery !== void 0 ? _kqlQuery$filterQuery : 'kuery',
        expression: (_kqlQuery$filterQuery4 = kqlQuery === null || kqlQuery === void 0 ? void 0 : (_kqlQuery$filterQuery5 = kqlQuery.filterQuery) === null || _kqlQuery$filterQuery5 === void 0 ? void 0 : (_kqlQuery$filterQuery6 = _kqlQuery$filterQuery5.kuery) === null || _kqlQuery$filterQuery6 === void 0 ? void 0 : _kqlQuery$filterQuery6.expression) !== null && _kqlQuery$filterQuery4 !== void 0 ? _kqlQuery$filterQuery4 : ''
      }
    };
    updateUrlParam(params);
  }, [activeTab, graphEventId, savedObjectId, show, updateUrlParam, savedSearchId, kqlQuery]);
};
exports.useSyncTimelineUrlParam = useSyncTimelineUrlParam;