"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withSecurityRoutePageWrapper = exports.SecurityRoutePageWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/usage-collection-plugin/public");
var _links = require("../../links");
var _no_privileges = require("../no_privileges");
var _use_upselling = require("../../hooks/use_upselling");
var _spy_routes = require("../../utils/route/spy_routes");
var _links_hooks = require("../../links/links_hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This component is created to wrap all the pages in the security solution app.
 *
 * It handles application tracking and upselling.
 *
 * When using this component make sure it render bellow `SecurityPageWrapper` and
 * that you removed the `TrackApplicationView` component.
 *
 * Ex:
 * ```
 * <PluginTemplateWrapper>
 *   <SecurityRoutePageWrapper pageName={SecurityPageName.myPage}>
 *     <MyPage />
 *   </SecurityRoutePageWrapper>
 * </PluginTemplateWrapper>
 * ```
 */
const SecurityRoutePageWrapper = exports.SecurityRoutePageWrapper = /*#__PURE__*/_react.default.memo(({
  children,
  pageName,
  omitSpyRoute = false,
  redirectOnMissing = false
}) => {
  const link = (0, _links.useLinkInfo)(pageName);
  const navLinkExists = (0, _links_hooks.useNavLinkExists)(pageName);
  const UpsellingPage = (0, _use_upselling.useUpsellingPage)(pageName);

  // The upselling page is only returned when the license/product requirements are not met.
  // When it is defined it must be rendered, no need to check anything else.
  if (UpsellingPage) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
      pageName: pageName
    }), /*#__PURE__*/_react.default.createElement(UpsellingPage, null));
  }

  // Redirect to the home page if the link is not found in the application links or in the registered navigation links.
  // If the `link == null` the `navLinkExists` will always be false, but adding the condition to avoid confusion.
  if (redirectOnMissing && (link == null || !navLinkExists)) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: ""
    });
  }

  // Show the no privileges page if the link is not found or unauthorized.
  if (link == null || link.unauthorized) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
      pageName: pageName
    }), /*#__PURE__*/_react.default.createElement(_no_privileges.NoPrivilegesPage, {
      pageName: pageName,
      docLinkSelector: docLinks => docLinks.siem.privileges
    }));
  }

  // Show the actual application page.
  return /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
    viewId: pageName
  }, children, !omitSpyRoute && /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: pageName
  }));
});
SecurityRoutePageWrapper.displayName = 'SecurityRoutePageWrapper';

/**
 * HOC to wrap a component with the `SecurityRoutePageWrapper`.
 */
const withSecurityRoutePageWrapper = (Component, pageName, options = {}) => {
  return /*#__PURE__*/_react.default.memo(function WithSecurityRoutePageWrapper(props) {
    return /*#__PURE__*/_react.default.createElement(SecurityRoutePageWrapper, (0, _extends2.default)({
      pageName: pageName
    }, options), /*#__PURE__*/_react.default.createElement(Component, props));
  });
};
exports.withSecurityRoutePageWrapper = withSecurityRoutePageWrapper;