"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoPrivilegesPage = exports.NoPrivileges = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _kibana = require("../../lib/kibana");
var _page_wrapper = require("../page_wrapper");
var _empty_page = require("../empty_page");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SizedEuiFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  min-height: 460px;
  font-size: 1.1rem;
`;
const NoPrivilegesPage = exports.NoPrivilegesPage = /*#__PURE__*/_react.default.memo(({
  pageName,
  docLinkSelector
}) => /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(SizedEuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, null, /*#__PURE__*/_react.default.createElement(NoPrivileges, {
  pageName: pageName,
  docLinkSelector: docLinkSelector
}))))));
NoPrivilegesPage.displayName = 'NoPrivilegePage';
const NoPrivileges = exports.NoPrivileges = /*#__PURE__*/_react.default.memo(({
  pageName,
  docLinkSelector
}) => {
  const {
    docLinks
  } = (0, _kibana.useKibana)().services;
  const emptyPageActions = (0, _react.useMemo)(() => ({
    feature: {
      icon: 'documents',
      label: i18n.GO_TO_DOCUMENTATION,
      url: docLinkSelector(docLinks.links),
      target: '_blank'
    }
  }), [docLinkSelector, docLinks.links]);
  const message = pageName ? i18n.NO_PRIVILEGES_PER_PAGE_MESSAGE(pageName) : i18n.NO_PRIVILEGES_DEFAULT_MESSAGE;
  return /*#__PURE__*/_react.default.createElement(_empty_page.EmptyPage, {
    actions: emptyPageActions,
    message: message,
    "data-test-subj": "noPrivilegesPage",
    title: i18n.NO_PERMISSIONS_TITLE
  });
});
NoPrivileges.displayName = 'NoPrivileges';