"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetJobs = exports.useGetInstalledJob = void 0;
var _react = require("react");
var _securitysolutionHookUtils = require("@kbn/securitysolution-hook-utils");
var _get_jobs = require("../api/get_jobs");
var _has_ml_user_permissions = require("../../../../../common/machine_learning/has_ml_user_permissions");
var _has_ml_license = require("../../../../../common/machine_learning/has_ml_license");
var _use_app_toasts = require("../../../hooks/use_app_toasts");
var _kibana = require("../../../lib/kibana");
var _use_ml_capabilities = require("./use_ml_capabilities");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const _getJobs = (0, _securitysolutionHookUtils.withOptionalSignal)(_get_jobs.getJobs);
const useGetJobs = () => (0, _securitysolutionHookUtils.useAsync)(_getJobs);
exports.useGetJobs = useGetJobs;
// TODO react-query
const useGetInstalledJob = jobIds => {
  const [jobs, setJobs] = (0, _react.useState)([]);
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const mlCapabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  const http = (0, _kibana.useHttp)();
  const {
    error,
    loading,
    result,
    start
  } = useGetJobs();
  const isMlUser = (0, _has_ml_user_permissions.hasMlUserPermissions)(mlCapabilities);
  const isLicensed = (0, _has_ml_license.hasMlLicense)(mlCapabilities);
  (0, _react.useEffect)(() => {
    if (isMlUser && isLicensed && jobIds.length > 0) {
      start({
        http,
        jobIds
      });
    }
  }, [http, isMlUser, isLicensed, start, jobIds]);
  (0, _react.useEffect)(() => {
    if (result) {
      setJobs(result);
    }
  }, [result]);
  (0, _react.useEffect)(() => {
    if (error) {
      addError(error, {
        title: i18n.SIEM_JOB_FETCH_FAILURE
      });
    }
  }, [addError, error]);
  return {
    isLicensed,
    isMlUser,
    jobs,
    loading
  };
};
exports.useGetInstalledJob = useGetInstalledJob;