"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNetworkUrl = exports.getNetworkDetailsUrl = void 0;
var _network = require("../../../../common/search_strategy/security_solution/network");
var _types = require("../../../explore/network/pages/details/types");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getNetworkUrl = search => `${(0, _helpers.appendSearch)(search)}`;
exports.getNetworkUrl = getNetworkUrl;
const getNetworkDetailsUrl = (detailName, flowTarget, search, tabName = _types.NetworkDetailsRouteType.events) => `/ip/${detailName}/${flowTarget || _network.FlowTarget.source}/${tabName}${(0, _helpers.appendSearch)(search)}`;
exports.getNetworkDetailsUrl = getNetworkDetailsUrl;