"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LineClamp = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_is_overflow = require("../../hooks/use_is_overflow");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LINE_CLAMP = 3;
const LINE_CLAMP_HEIGHT = '5.5em';
const MAX_HEIGHT = '33vh';
const ReadMore = (0, _styledComponents.default)(_eui.EuiButtonEmpty)`
  span.euiButtonContent {
    padding: 0;
  }
`;
const ExpandedContent = _styledComponents.default.div`
  max-height: ${({
  maxHeight
}) => maxHeight};
  overflow-wrap: break-word;
  overflow-x: hidden;
  overflow-y: auto;
`;
const StyledLineClamp = _styledComponents.default.div`
  display: -webkit-box;
  -webkit-line-clamp: ${({
  lineClamp
}) => lineClamp};
  -webkit-box-orient: vertical;
  overflow: hidden;
  max-height: ${({
  lineClampHeight
}) => lineClampHeight};
  height: ${({
  lineClampHeight
}) => lineClampHeight};
`;
const LineClampComponent = ({
  children,
  lineClampHeight = LINE_CLAMP_HEIGHT,
  lineClamp = LINE_CLAMP,
  maxHeight = MAX_HEIGHT
}) => {
  const [isExpanded, setIsExpanded] = (0, _react.useState)(null);
  const [isOverflow, descriptionRef] = (0, _use_is_overflow.useIsOverflow)(children);
  const toggleReadMore = (0, _react.useCallback)(() => {
    setIsExpanded(prevState => !prevState);
  }, []);
  if (isExpanded) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(ExpandedContent, {
      maxHeight: maxHeight,
      "data-test-subj": "expanded-line-clamp"
    }, /*#__PURE__*/_react.default.createElement("p", null, children)), isOverflow && /*#__PURE__*/_react.default.createElement(ReadMore, {
      onClick: toggleReadMore,
      size: "s",
      "data-test-subj": "summary-view-readmore"
    }, i18n.READ_LESS));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isOverflow == null || isOverflow === true ? /*#__PURE__*/_react.default.createElement(StyledLineClamp, {
    "data-test-subj": "styled-line-clamp",
    ref: descriptionRef,
    lineClampHeight: lineClampHeight,
    lineClamp: lineClamp
  }, children) : children, isOverflow && /*#__PURE__*/_react.default.createElement(ReadMore, {
    onClick: toggleReadMore,
    size: "s",
    "data-test-subj": "summary-view-readmore"
  }, i18n.READ_MORE));
};
const LineClamp = exports.LineClamp = /*#__PURE__*/_react.default.memo(LineClampComponent);