"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FirstLastSeenType = exports.FirstLastSeen = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_first_last_seen = require("../../containers/use_first_last_seen");
var _empty_value = require("../empty_value");
var _formatted_date = require("../formatted_date");
var _search_strategy = require("../../../../common/search_strategy");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let FirstLastSeenType = exports.FirstLastSeenType = /*#__PURE__*/function (FirstLastSeenType) {
  FirstLastSeenType["FIRST_SEEN"] = "first-seen";
  FirstLastSeenType["LAST_SEEN"] = "last-seen";
  return FirstLastSeenType;
}({});
const FirstLastSeen = exports.FirstLastSeen = /*#__PURE__*/_react.default.memo(({
  indexPatterns,
  field,
  type,
  value
}) => {
  const [loading, {
    firstSeen,
    lastSeen,
    errorMessage
  }] = (0, _use_first_last_seen.useFirstLastSeen)({
    field,
    value,
    order: type === FirstLastSeenType.FIRST_SEEN ? _search_strategy.Direction.asc : _search_strategy.Direction.desc,
    defaultIndex: indexPatterns
  });
  const valueSeen = (0, _react.useMemo)(() => type === FirstLastSeenType.FIRST_SEEN ? firstSeen : lastSeen, [firstSeen, lastSeen, type]);
  if (errorMessage != null) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: errorMessage,
      "data-test-subj": "firstLastSeenErrorToolTip",
      "aria-label": `firstLastSeenError-${type}`,
      id: `firstLastSeenError-${field}-${type}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      "aria-describedby": `firstLastSeenError-${field}-${type}`,
      type: "warning"
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, loading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    "data-test-subj": "loading-spinner",
    size: "m"
  }), !loading && valueSeen != null && new Date(valueSeen).toString() === 'Invalid Date' ? valueSeen : !loading && valueSeen !== null && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "first-last-seen-value",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
    value: `${valueSeen}`
  })), !loading && valueSeen === null && (0, _empty_value.getEmptyTagValue)());
});
FirstLastSeen.displayName = 'FirstLastSeen';