"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertCountByRuleByStatus = exports.buildRuleAlertsByEntityQuery = exports.KIBANA_RULE_ID = void 0;
var _react = require("react");
var _ecs_safety_helpers = require("../../../../common/endpoint/models/ecs_safety_helpers");
var _constants = require("../../../detections/containers/detection_engine/alerts/constants");
var _use_query = require("../../../detections/containers/detection_engine/alerts/use_query");
var _use_global_time = require("../../containers/use_global_time");
var _manage_query = require("../page/manage_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERTS_BY_RULE_AGG = 'alertsByRuleAggregation';
const useAlertCountByRuleByStatus = ({
  additionalFilters,
  field,
  value,
  queryId,
  statuses,
  skip = false,
  signalIndexName
}) => {
  const [updatedAt, setUpdatedAt] = (0, _react.useState)(Date.now());
  const [items, setItems] = (0, _react.useState)([]);
  const {
    to,
    from,
    deleteQuery,
    setQuery
  } = (0, _use_global_time.useGlobalTime)();
  const {
    loading: isLoading,
    data,
    setQuery: setAlertsQuery,
    response,
    request,
    refetch: refetchQuery
  } = (0, _use_query.useQueryAlerts)({
    query: buildRuleAlertsByEntityQuery({
      additionalFilters,
      from,
      to,
      field,
      value,
      statuses
    }),
    skip,
    queryName: _constants.ALERTS_QUERY_NAMES.ALERTS_COUNT_BY_STATUS,
    indexName: signalIndexName
  });
  (0, _react.useEffect)(() => {
    setAlertsQuery(buildRuleAlertsByEntityQuery({
      additionalFilters,
      from,
      to,
      field,
      value,
      statuses
    }));
  }, [setAlertsQuery, from, to, field, value, statuses, additionalFilters]);
  (0, _react.useEffect)(() => {
    if (!data) {
      setItems([]);
    } else {
      setItems(parseAlertCountByRuleItems(data.aggregations));
    }
    setUpdatedAt(Date.now());
  }, [data]);
  const refetch = (0, _react.useCallback)(() => {
    if (!skip && refetchQuery) {
      refetchQuery();
    }
  }, [skip, refetchQuery]);
  (0, _manage_query.useQueryInspector)({
    deleteQuery,
    inspect: {
      dsl: [request],
      response: [response]
    },
    refetch,
    setQuery,
    queryId,
    loading: isLoading
  });
  return {
    items,
    isLoading,
    updatedAt
  };
};
exports.useAlertCountByRuleByStatus = useAlertCountByRuleByStatus;
const KIBANA_RULE_ID = exports.KIBANA_RULE_ID = 'kibana.alert.rule.uuid';
const buildRuleAlertsByEntityQuery = ({
  additionalFilters = [],
  from,
  to,
  field,
  value,
  statuses
}) => ({
  size: 0,
  _source: false,
  fields: [KIBANA_RULE_ID],
  query: {
    bool: {
      filter: [...additionalFilters, {
        range: {
          '@timestamp': {
            gte: from,
            lte: to
          }
        }
      }, ...((statuses === null || statuses === void 0 ? void 0 : statuses.length) > 0 ? [{
        terms: {
          'kibana.alert.workflow_status': statuses
        }
      }] : []), {
        term: {
          [field]: value
        }
      }]
    }
  },
  aggs: {
    [ALERTS_BY_RULE_AGG]: {
      terms: {
        field: 'kibana.alert.rule.name',
        size: 100
      },
      aggs: {
        ruleUuid: {
          top_hits: {
            _source: false,
            fields: [KIBANA_RULE_ID],
            size: 1
          }
        }
      }
    }
  }
});
exports.buildRuleAlertsByEntityQuery = buildRuleAlertsByEntityQuery;
const parseAlertCountByRuleItems = aggregations => {
  var _aggregations$ALERTS_;
  const buckets = (_aggregations$ALERTS_ = aggregations === null || aggregations === void 0 ? void 0 : aggregations[ALERTS_BY_RULE_AGG].buckets) !== null && _aggregations$ALERTS_ !== void 0 ? _aggregations$ALERTS_ : [];
  return buckets.map(bucket => {
    var _firstNonNullValue, _bucket$ruleUuid$hits, _bucket$ruleUuid$hits2, _firstNonNullValue2;
    const uuid = (_firstNonNullValue = (0, _ecs_safety_helpers.firstNonNullValue)((_bucket$ruleUuid$hits = bucket.ruleUuid.hits) === null || _bucket$ruleUuid$hits === void 0 ? void 0 : (_bucket$ruleUuid$hits2 = _bucket$ruleUuid$hits.hits[0]) === null || _bucket$ruleUuid$hits2 === void 0 ? void 0 : _bucket$ruleUuid$hits2.fields['kibana.alert.rule.uuid'])) !== null && _firstNonNullValue !== void 0 ? _firstNonNullValue : '';
    return {
      ruleName: (_firstNonNullValue2 = (0, _ecs_safety_helpers.firstNonNullValue)(bucket.key)) !== null && _firstNonNullValue2 !== void 0 ? _firstNonNullValue2 : '-',
      count: bucket.doc_count,
      uuid
    };
  });
};