"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNonClosedAlerts = void 0;
var _react = require("react");
var _types = require("@kbn/securitysolution-data-table/common/types");
var _use_signal_index = require("../../detections/containers/detection_engine/alerts/use_signal_index");
var _use_alerts_by_status = require("../../overview/components/detection_response/alerts_by_status/use_alerts_by_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useNonClosedAlerts = ({
  field,
  value,
  to,
  from,
  queryId
}) => {
  var _filteredAlertsData$a, _filteredAlertsData$o;
  const {
    signalIndexName
  } = (0, _use_signal_index.useSignalIndex)();
  const entityFilter = (0, _react.useMemo)(() => ({
    field,
    value
  }), [field, value]);
  const {
    items: alertsData
  } = (0, _use_alerts_by_status.useAlertsByStatus)({
    entityFilter,
    signalIndexName,
    queryId,
    to,
    from
  });
  const filteredAlertsData = alertsData ? Object.fromEntries(Object.entries(alertsData).filter(([key]) => key !== _types.FILTER_CLOSED)) : {};
  const hasNonClosedAlerts = ((filteredAlertsData === null || filteredAlertsData === void 0 ? void 0 : (_filteredAlertsData$a = filteredAlertsData.acknowledged) === null || _filteredAlertsData$a === void 0 ? void 0 : _filteredAlertsData$a.total) || 0) + ((filteredAlertsData === null || filteredAlertsData === void 0 ? void 0 : (_filteredAlertsData$o = filteredAlertsData.open) === null || _filteredAlertsData$o === void 0 ? void 0 : _filteredAlertsData$o.total) || 0) > 0;
  return {
    hasNonClosedAlerts,
    filteredAlertsData
  };
};
exports.useNonClosedAlerts = useNonClosedAlerts;