"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchScheduleRuleType = void 0;
var _lodash = require("lodash");
var _reactQuery = require("@kbn/react-query");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants = require("./constants");
var _api = require("../api");
var _use_app_toasts = require("../../../../../common/hooks/use_app_toasts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchScheduleRuleType = () => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  return (0, _reactQuery.useQuery)(['GET', _api.ALERTING_RULE_TYPES_URL], async ({
    signal
  }) => {
    var _response$find;
    const res = await (0, _api.fetchRuleTypes)({
      signal
    });
    const response = res.map(item => {
      return (0, _lodash.mapKeys)(item, (_, k) => (0, _lodash.camelCase)(k));
    });
    return (_response$find = response.find(item => item.id === _elasticAssistantCommon.ATTACK_DISCOVERY_SCHEDULES_ALERT_TYPE_ID)) !== null && _response$find !== void 0 ? _response$find : null;
  }, {
    ..._constants.DEFAULT_QUERY_OPTIONS,
    onError: error => {
      addError(error, {
        title: i18n.FETCH_ATTACK_DISCOVERY_SCHEDULE_RULE_TYPE_FAILURE
      });
    }
  });
};
exports.useFetchScheduleRuleType = useFetchScheduleRuleType;