"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.STEP = exports.NO_INDEX_PATTERNS = exports.MIN_ALERTS = exports.MAX_ALERTS = exports.AlertSelectionRange = void 0;
var _eui = require("@elastic/eui");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("../translations"));
var _use_kibana_feature_flags = require("../../../use_kibana_feature_flags");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_ALERTS = exports.MAX_ALERTS = 500;
const MIN_ALERTS = exports.MIN_ALERTS = 50;
const STEP = exports.STEP = 50;
const NO_INDEX_PATTERNS = exports.NO_INDEX_PATTERNS = [];
const AlertSelectionRangeComponent = ({
  maxAlerts,
  setMaxAlerts
}) => {
  const {
    attackDiscoveryAlertsEnabled
  } = (0, _use_kibana_feature_flags.useKibanaFeatureFlags)();

  // called when the slider changes the number of alerts to analyze:
  const onChangeAlertsRange = (0, _react.useCallback)(e => {
    setMaxAlerts(e.currentTarget.value);
  }, [setMaxAlerts]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "alertSelectionRange",
    direction: "column",
    gutterSize: "none"
  }, !attackDiscoveryAlertsEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "title",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, i18n.SET_NUMBER_OF_ALERTS_TO_ANALYZE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_elasticAssistant.AlertsRange, {
    maxAlerts: MAX_ALERTS,
    minAlerts: MIN_ALERTS,
    onChange: onChangeAlertsRange,
    step: STEP,
    value: maxAlerts
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    "data-test-subj": "sendFewerAlerts",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("span", null, i18n.SEND_FEWER_ALERTS))));
};
AlertSelectionRangeComponent.displayName = 'AlertSelectionRange';
const AlertSelectionRange = exports.AlertSelectionRange = /*#__PURE__*/_react.default.memo(AlertSelectionRangeComponent);