"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SendToTimelineButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _react2 = require("@emotion/react");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _timeline_capabilities = require("../../common/utils/timeline_capabilities");
var _store = require("../../common/store");
var _actions = require("../../common/store/actions");
var _inputs = require("../../common/store/inputs");
var _constants = require("../../common/store/inputs/constants");
var _model = require("../../sourcerer/store/model");
var _timeline = require("../../../common/types/timeline");
var _translations = require("../../detections/components/alerts_table/translations");
var _actions2 = require("../../timelines/store/actions");
var _use_discover_in_timeline_context = require("../../common/components/discover_in_timeline/use_discover_in_timeline_context");
var _use_show_timeline = require("../../common/utils/timeline/use_show_timeline");
var _containers = require("../../sourcerer/containers");
var _use_discover_state = require("../../timelines/components/timeline/tabs/esql/use_discover_state");
var _kibana = require("../../common/lib/kibana");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
var _use_data_view = require("../../data_view_manager/hooks/use_data_view");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SendToTimelineButton = ({
  asEmptyButton,
  children,
  dataProviders,
  filters,
  timeRange,
  keepDataView,
  ...rest
}) => {
  var _experimentalDataView;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    showAssistantOverlay
  } = (0, _elasticAssistant.useAssistantContext)();
  const [isTimelineBottomBarVisible] = (0, _use_show_timeline.useShowTimeline)();
  const {
    discoverStateContainer,
    defaultDiscoverAppState
  } = (0, _use_discover_in_timeline_context.useDiscoverInTimelineContext)();
  const {
    dataViewId: oldTimelineDataViewId
  } = (0, _containers.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)(_model.SourcererScopeName.timeline);
  const timelineDataViewId = newDataViewPickerEnabled ? (_experimentalDataView = experimentalDataView.id) !== null && _experimentalDataView !== void 0 ? _experimentalDataView : null : oldTimelineDataViewId;
  const {
    setDiscoverAppState
  } = (0, _use_discover_state.useDiscoverState)();
  const {
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  const {
    read: hasAccessToTimeline
  } = (0, _timeline_capabilities.extractTimelineCapabilities)(capabilities);
  const signalIndexName = (0, _reactRedux.useSelector)(_store.sourcererSelectors.signalIndexName);
  const defaultDataView = (0, _reactRedux.useSelector)(_store.sourcererSelectors.defaultDataView);
  const configureAndOpenTimeline = (0, _react.useCallback)(async () => {
    // Hide the assistant overlay so timeline can be seen (noop if using assistant in timeline)
    showAssistantOverlay({
      showOverlay: false
    });
    if (dataProviders || filters) {
      var _dataProviders$, _dataProviders$2;
      // If esql, don't reset filters or mess with dataview & time range
      if ((dataProviders === null || dataProviders === void 0 ? void 0 : (_dataProviders$ = dataProviders[0]) === null || _dataProviders$ === void 0 ? void 0 : _dataProviders$.queryType) === 'esql' || (dataProviders === null || dataProviders === void 0 ? void 0 : (_dataProviders$2 = dataProviders[0]) === null || _dataProviders$2 === void 0 ? void 0 : _dataProviders$2.queryType) === 'sql') {
        if (discoverStateContainer.current) {
          var _discoverStateContain, _discoverStateContain2;
          (_discoverStateContain = discoverStateContainer.current) === null || _discoverStateContain === void 0 ? void 0 : _discoverStateContain.appState.set({
            query: {
              esql: dataProviders[0].kqlQuery
            }
          });
          await ((_discoverStateContain2 = discoverStateContainer.current) === null || _discoverStateContain2 === void 0 ? void 0 : _discoverStateContain2.appState.replaceUrlState({
            query: {
              esql: dataProviders[0].kqlQuery
            }
          }));
        } else {
          setDiscoverAppState({
            ...defaultDiscoverAppState,
            query: {
              esql: dataProviders[0].kqlQuery
            }
          });
        }
        dispatch((0, _actions2.setActiveTabTimeline)({
          id: _timeline.TimelineId.active,
          activeTab: _timeline.TimelineTabs.esql
        }));
        dispatch((0, _actions2.showTimeline)({
          id: _timeline.TimelineId.active,
          show: true
        }));
        return;
      }
      if (dataProviders) {
        // Ensure Security Solution Default DataView is selected (so it's not just alerts)
        dispatch((0, _actions2.updateDataView)({
          id: _timeline.TimelineId.active,
          dataViewId: 'security-solution-default',
          indexNames: ['logs-*']
        }));

        // Added temporary queryType to dataproviders to support EQL/DSL
        switch (dataProviders[0].queryType) {
          case 'eql':
            // is EQL
            dispatch((0, _actions2.updateEqlOptions)({
              id: _timeline.TimelineId.active,
              field: 'query',
              value: dataProviders[0].kqlQuery
            }));
            dispatch((0, _actions2.setActiveTabTimeline)({
              id: _timeline.TimelineId.active,
              activeTab: _timeline.TimelineTabs.eql
            }));
            dispatch((0, _actions2.showTimeline)({
              id: _timeline.TimelineId.active,
              show: true
            }));
            break;
          case 'kql':
            // is KQL
            dispatch((0, _actions2.applyKqlFilterQuery)({
              id: _timeline.TimelineId.active,
              filterQuery: {
                kuery: {
                  kind: 'kuery',
                  expression: dataProviders[0].kqlQuery
                },
                serializedQuery: dataProviders[0].kqlQuery
              }
            }));
            dispatch((0, _actions2.setActiveTabTimeline)({
              id: _timeline.TimelineId.active,
              activeTab: _timeline.TimelineTabs.query
            }));
            dispatch((0, _actions2.showTimeline)({
              id: _timeline.TimelineId.active,
              show: true
            }));
            break;
          case 'dsl':
            const filter = {
              meta: {
                type: 'custom',
                disabled: false,
                negate: false,
                alias: dataProviders[0].name,
                key: 'query',
                value: dataProviders[0].kqlQuery,
                index: timelineDataViewId !== null && timelineDataViewId !== void 0 ? timelineDataViewId : undefined
              },
              query: JSON.parse(dataProviders[0].kqlQuery)
            };
            dispatch((0, _actions2.setFilters)({
              id: _timeline.TimelineId.active,
              filters: [filter]
            }));
            dispatch((0, _actions2.setActiveTabTimeline)({
              id: _timeline.TimelineId.active,
              activeTab: _timeline.TimelineTabs.query
            }));
            dispatch((0, _actions2.showTimeline)({
              id: _timeline.TimelineId.active,
              show: true
            }));
            break;
        }
      }

      // Use filters if more than a certain amount of ids for dom performance.
      if (filters) {
        dispatch((0, _actions2.setFilters)({
          id: _timeline.TimelineId.active,
          filters
        }));
      }
      // Only show detection alerts
      // (This is required so the timeline event count matches the prevalence count)
      if (!keepDataView) {
        dispatch(_actions.sourcererActions.setSelectedDataView({
          id: _model.SourcererScopeName.timeline,
          selectedDataViewId: defaultDataView.id,
          selectedPatterns: [signalIndexName || '']
        }));
      }
      // Unlock the time range from the global time range
      dispatch(_inputs.inputsActions.removeLinkTo([_constants.InputsModelId.timeline, _constants.InputsModelId.global]));
    }
  }, [showAssistantOverlay, dataProviders, filters, keepDataView, dispatch, discoverStateContainer, timelineDataViewId, defaultDataView.id, signalIndexName, setDiscoverAppState, defaultDiscoverAppState]);

  // As we work around timeline visibility issues, we will disable the button if timeline isn't available
  const toolTipText = isTimelineBottomBarVisible ? _translations.ACTION_INVESTIGATE_IN_TIMELINE : _translations.ACTION_CANNOT_INVESTIGATE_IN_TIMELINE;
  const isDisabled = !isTimelineBottomBarVisible;
  if (!hasAccessToTimeline) {
    return null;
  }
  return asEmptyButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": toolTipText,
    onClick: configureAndOpenTimeline,
    isDisabled: isDisabled,
    color: "text",
    flush: "both",
    "data-test-subj": "sendToTimelineEmptyButton",
    size: "xs",
    css: (0, _react2.css)`
        width: 100%;
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "right",
    content: toolTipText
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children))) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    "aria-label": toolTipText,
    isDisabled: isDisabled,
    onClick: configureAndOpenTimeline,
    "data-test-subj": "sendToTimelineButton"
  }, rest), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "right",
    content: toolTipText
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children)));
};
exports.SendToTimelineButton = SendToTimelineButton;
SendToTimelineButton.displayName = 'SendToTimelineButton';