"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityApp = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/kibana-react-plugin/common");
var _cellActions = require("@kbn/cell-actions");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _upselling_provider = require("../common/components/upselling_provider");
var _user_info = require("../detections/components/user_info");
var _constants = require("../../common/constants");
var _error_toast_dispatcher = require("../common/components/error_toast_dispatcher");
var _ml_capabilities_provider = require("../common/components/ml/permissions/ml_capabilities_provider");
var _toasters = require("../common/components/toasters");
var _kibana = require("../common/lib/kibana");
var _routes = require("./routes");
var _user_privileges_context = require("../common/components/user_privileges/user_privileges_context");
var _query_client_provider = require("../common/containers/query_client/query_client_provider");
var _provider = require("../common/components/discover_in_timeline/provider");
var _provider2 = require("../assistant/provider");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StartAppComponent = ({
  children,
  history,
  store,
  theme$
}) => {
  const services = (0, _kibana.useKibana)().services;
  const {
    application: {
      capabilities
    },
    uiActions,
    upselling
  } = services;
  const darkMode = (0, _public.useDarkMode)();
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, services, /*#__PURE__*/_react.default.createElement(_toasters.ManageGlobalToaster, null, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: store
  }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: darkMode
  }, /*#__PURE__*/_react.default.createElement(_ml_capabilities_provider.MlCapabilitiesProvider, null, /*#__PURE__*/_react.default.createElement(_user_privileges_context.UserPrivilegesProvider, {
    kibanaCapabilities: capabilities
  }, /*#__PURE__*/_react.default.createElement(_user_info.ManageUserInfo, null, /*#__PURE__*/_react.default.createElement(_securitySolutionNavigation.NavigationProvider, {
    core: services
  }, /*#__PURE__*/_react.default.createElement(_query_client_provider.ReactQueryClientProvider, null, /*#__PURE__*/_react.default.createElement(_cellActions.CellActionsProvider, {
    getTriggerCompatibleActions: uiActions.getTriggerCompatibleActions
  }, /*#__PURE__*/_react.default.createElement(_upselling_provider.UpsellingProvider, {
    upsellingService: upselling
  }, /*#__PURE__*/_react.default.createElement(_provider.DiscoverInTimelineContextProvider, null, /*#__PURE__*/_react.default.createElement(_routes.PageRouter, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_provider2.AssistantProvider, null, children))))))))))), /*#__PURE__*/_react.default.createElement(_error_toast_dispatcher.ErrorToastDispatcher, null), /*#__PURE__*/_react.default.createElement(_toasters.GlobalToaster, null))));
};
const StartApp = /*#__PURE__*/(0, _react.memo)(StartAppComponent);
const SecurityAppComponent = ({
  children,
  history,
  services,
  store,
  theme$
}) => {
  var _services$cloud$Cloud, _services$cloud;
  const CloudProvider = (_services$cloud$Cloud = (_services$cloud = services.cloud) === null || _services$cloud === void 0 ? void 0 : _services$cloud.CloudContextProvider) !== null && _services$cloud$Cloud !== void 0 ? _services$cloud$Cloud : _react.default.Fragment;
  return /*#__PURE__*/_react.default.createElement(_kibana.KibanaContextProvider, {
    services: {
      appName: _constants.APP_NAME,
      ...services
    }
  }, /*#__PURE__*/_react.default.createElement(CloudProvider, null, /*#__PURE__*/_react.default.createElement(StartApp, {
    history: history,
    store: store,
    theme$: theme$
  }, children)));
};
const SecurityApp = exports.SecurityApp = /*#__PURE__*/(0, _react.memo)(SecurityAppComponent);