"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TITLE = exports.RULES_TITLE = exports.RULES_MANUAL_TITLE = exports.RULES_MANUAL_DESCRIPTION = exports.RULES_DESCRIPTION = exports.LINK_TEXT = exports.DOCS = exports.DESCRIPTION = exports.CASES_TITLE = exports.CASES_MANUAL_TITLE = exports.CASES_MANUAL_DESCRIPTION = exports.CASES_DESCRIPTION = exports.ADD_DATA_TITLE = exports.ADD_DATA_DESCRIPTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TITLE = exports.TITLE = _i18n.i18n.translate('xpack.securitySolution.guideConfig.title', {
  defaultMessage: 'Detect threats in my data with Security Solution'
});
const DESCRIPTION = exports.DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.guideConfig.description', {
  defaultMessage: `Welcome to Elastic Security for SIEM. In this guide, you'll learn how to analyze log and event data, set up threat detection, and respond to threats.`
});
const DOCS = exports.DOCS = _i18n.i18n.translate('xpack.securitySolution.guideConfig.documentationLink', {
  defaultMessage: 'Learn more'
});
const LINK_TEXT = exports.LINK_TEXT = _i18n.i18n.translate('xpack.securitySolution.guideConfig.addDataStep.description.linkText', {
  defaultMessage: 'Learn more'
});
const ADD_DATA_TITLE = exports.ADD_DATA_TITLE = _i18n.i18n.translate('xpack.securitySolution.guideConfig.addDataStep.title', {
  defaultMessage: 'Send log and event data to Elastic'
});
const ADD_DATA_DESCRIPTION = exports.ADD_DATA_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.guideConfig.addDataStep.description', {
  defaultMessage: 'Install an agent on one of your computers and configure it with the Elastic Defend integration. With this integration, the agent will be able to collect and send system data to Elastic Security in real time.'
});
const RULES_TITLE = exports.RULES_TITLE = _i18n.i18n.translate('xpack.securitySolution.guideConfig.rulesStep.title', {
  defaultMessage: 'Turn on rules'
});
const RULES_DESCRIPTION = exports.RULES_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.guideConfig.rulesStep.description', {
  defaultMessage: 'Load the Elastic prebuilt rules, select the rules you want, and enable them to generate alerts.'
});
const RULES_MANUAL_TITLE = exports.RULES_MANUAL_TITLE = _i18n.i18n.translate('xpack.securitySolution.guideConfig.rulesStep.manualCompletion.title', {
  defaultMessage: 'Continue with the guide'
});
const RULES_MANUAL_DESCRIPTION = exports.RULES_MANUAL_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.guideConfig.rulesStep.manualCompletion.description', {
  defaultMessage: `After you've enabled the rules you need, continue.`
});
const CASES_TITLE = exports.CASES_TITLE = _i18n.i18n.translate('xpack.securitySolution.guideConfig.alertsStep.title', {
  defaultMessage: 'Manage alerts and cases'
});
const CASES_DESCRIPTION = exports.CASES_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.guideConfig.alertsStep.description', {
  defaultMessage: 'Learn how to view and triage alerts with cases.'
});
const CASES_MANUAL_TITLE = exports.CASES_MANUAL_TITLE = _i18n.i18n.translate('xpack.securitySolution.guideConfig.alertsStep.manualCompletion.title', {
  defaultMessage: 'Continue the guide'
});
const CASES_MANUAL_DESCRIPTION = exports.CASES_MANUAL_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.guideConfig.alertsStep.manualCompletion.description', {
  defaultMessage: `View the case's details by clicking View case in the confirmation message that appears. Alternatively, go to the Insights section of the alert details flyout, find the case you created, and select it. After you've explored the case, continue.`
});