"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractRuleKqlQuery = exports.extractRuleEsqlQuery = exports.extractRuleEqlQuery = exports.extractInlineKqlQuery = void 0;
var _prebuilt_rules = require("../../../api/detection_engine/prebuilt_rules");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const extractRuleKqlQuery = (query, language, filters, savedQueryId) => {
  if (savedQueryId != null) {
    return {
      type: _prebuilt_rules.KqlQueryType.saved_query,
      saved_query_id: savedQueryId
    };
  } else {
    return extractInlineKqlQuery(query, language, filters);
  }
};
exports.extractRuleKqlQuery = extractRuleKqlQuery;
const extractInlineKqlQuery = (query, language, filters) => {
  var _query$trim;
  return {
    type: _prebuilt_rules.KqlQueryType.inline_query,
    query: (_query$trim = query === null || query === void 0 ? void 0 : query.trim()) !== null && _query$trim !== void 0 ? _query$trim : '',
    language: language !== null && language !== void 0 ? language : 'kuery',
    filters: normalizeFilterArray(filters)
  };
};
exports.extractInlineKqlQuery = extractInlineKqlQuery;
const extractRuleEqlQuery = params => {
  var _params$query;
  return {
    query: (_params$query = params.query) === null || _params$query === void 0 ? void 0 : _params$query.trim(),
    language: params.language,
    filters: normalizeFilterArray(params.filters),
    event_category_override: params.eventCategoryOverride,
    timestamp_field: params.timestampField,
    tiebreaker_field: params.tiebreakerField
  };
};
exports.extractRuleEqlQuery = extractRuleEqlQuery;
const extractRuleEsqlQuery = (query, language) => {
  return {
    query: query === null || query === void 0 ? void 0 : query.trim(),
    language
  };
};

/**
 * Normalizes filter properties to only include ones relevant to the query itself
 * Relevant issues:
 *  - https://github.com/elastic/kibana/issues/202966
 *  - https://github.com/elastic/kibana/issues/206527
 */
exports.extractRuleEsqlQuery = extractRuleEsqlQuery;
const normalizeFilterArray = filters => {
  if (!(filters !== null && filters !== void 0 && filters.length)) {
    return [];
  }
  return filters.map(filter => {
    var _filter$meta, _filter$meta$type, _filter$meta$alias, _filter$meta$key;
    return {
      query: filter.query,
      meta: filter.meta ? {
        negate: filter.meta.negate,
        disabled: filter.meta.disabled !== undefined ? filter.meta.disabled : false,
        params: filter.meta.params,
        relation: 'relation' in filter.meta ? (_filter$meta = filter.meta) === null || _filter$meta === void 0 ? void 0 : _filter$meta.relation : undefined,
        type: (_filter$meta$type = filter.meta.type) !== null && _filter$meta$type !== void 0 ? _filter$meta$type : 'custom',
        alias: (_filter$meta$alias = filter.meta.alias) !== null && _filter$meta$alias !== void 0 ? _filter$meta$alias : undefined,
        key: (_filter$meta$key = filter.meta.key) !== null && _filter$meta$key !== void 0 ? _filter$meta$key : undefined
      } : undefined
    };
  });
};