"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReadAlertsMigrationStatusResponse = exports.ReadAlertsMigrationStatusRequestQuery = exports.MigrationStatus = exports.IndexMigrationStatus = exports.AlertVersion = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _primitives = require("../../../model/primitives.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Read alerts migration status API endpoint
 *   version: 2023-10-31
 */

const AlertVersion = exports.AlertVersion = _zod.z.object({
  version: _zod.z.number().int(),
  count: _zod.z.number().int()
});
const MigrationStatus = exports.MigrationStatus = _zod.z.object({
  id: _primitives.NonEmptyString,
  status: _zod.z.enum(['success', 'failure', 'pending']),
  version: _zod.z.number().int(),
  updated: _zod.z.string().datetime()
});
const IndexMigrationStatus = exports.IndexMigrationStatus = _zod.z.object({
  index: _primitives.NonEmptyString,
  version: _zod.z.number().int(),
  signal_versions: _zod.z.array(AlertVersion),
  migrations: _zod.z.array(MigrationStatus),
  is_outdated: _zod.z.boolean()
});
const ReadAlertsMigrationStatusRequestQuery = exports.ReadAlertsMigrationStatusRequestQuery = _zod.z.object({
  /**
   * Maximum age of qualifying detection alerts
   */
  from: _zod.z.string().superRefine(_zodHelpers.isValidDateMath)
});
const ReadAlertsMigrationStatusResponse = exports.ReadAlertsMigrationStatusResponse = _zod.z.object({
  indices: _zod.z.array(IndexMigrationStatus)
});