"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReviewRuleInstallationRequestBody = void 0;
var _zod = require("@kbn/zod");
var _prebuilt_rule_assets_filter = require("../common/prebuilt_rule_assets_filter");
var _prebuilt_rule_assets_sort = require("../common/prebuilt_rule_assets_sort");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ReviewRuleInstallationRequestBody = exports.ReviewRuleInstallationRequestBody = _zod.z.object({
  /**
   * Page number starting from 1
   */
  page: _zod.z.number().int().min(1).default(1),
  /**
   * Rules per page
   */
  per_page: _zod.z.number().int().min(1).max(10_000).default(20),
  /**
   * Filtering criteria
   */
  filter: _prebuilt_rule_assets_filter.PrebuiltRuleAssetsFilter.optional(),
  /**
   * Sorting criteria
   */
  sort: _prebuilt_rule_assets_sort.PrebuiltRuleAssetsSort.optional()
});