"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrebuiltRuleAssetsSortItem = exports.PrebuiltRuleAssetsSortField = exports.PrebuiltRuleAssetsSort = void 0;
var _zod = require("@kbn/zod");
var _model = require("../../model");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PrebuiltRuleAssetsSortField = exports.PrebuiltRuleAssetsSortField = _zod.z.enum(['name', 'risk_score', 'severity']);
const PrebuiltRuleAssetsSortItem = exports.PrebuiltRuleAssetsSortItem = _zod.z.object({
  /**
   * Field to sort by
   */
  field: PrebuiltRuleAssetsSortField,
  /**
   * Sort order
   */
  order: _model.SortOrder
});
const PrebuiltRuleAssetsSort = exports.PrebuiltRuleAssetsSort = _zod.z.array(PrebuiltRuleAssetsSortItem);